@extends('system.layout.main', [
    'ngController' => 'FaqController'
])
@section('title')
    <title>Cấu hình faq</title>
@endsection
@section('script')
    <script src="/system/js/scripts/ckeditor/ckeditor.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="/modules/seo/js/faq.module.controller.js?v=<?= time() ?>"></script>
@endsection

@section('css')
    <style>
        .btn-upload-image {
            border: 1px solid #d3d3d39c;
            padding: 7px;
            display: inline-block;
            border-radius: 5px;
            font-size: 13px;
            background-color: #f0f0f08c;
            cursor: pointer;
            vertical-align: top;
        }
        .chosen-container.chosen-container-single {
            width: 100% !important; /* or any value that fits your needs */
        }
    </style>
    <link rel="stylesheet" type="text/css" href="/modules/seo/css/redirect.css?v=<?= time() ?>" />
    <link rel="stylesheet" type="text/css" href="/modules/seo/css/faq.css?v=<?= time() ?>" />
@endsection

@section('content')
    <div class="content" ng-cloak>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    @include('seo::admin.faq.filters')
                    @include('seo::admin.faq.list')
                    @include('seo::admin.faq.modal')
                    @view('system.seo.includes.paginator', [
                        "accessPageId" => "filters.page_id",
                        "accessPagesCount" => "pagesCount",
                        "accessFind" => "find()"
                    ])
                </div>
            </div>
        </div>
    </div>
@endsection