@extends('system.layout.main', [
'ngController' => 'HreflangController'
])
@section('title')
<title>Cấu hình Hreflang</title>
@endsection

@section('content')
<section class="content" ng-cloak>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">Danh sách Hreflang</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-primary" ngf-select ng-model="excelFile" ng-change="handleUpload(excelFile)" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" ngf-max-size="5MB" ><i class="fa fa-upload"></i> Nhập Excel</button>
                        <button type="button" class="btn btn-primary" ng-click="downloadTemplate()"><i class="fa fa-file-excel-o"></i> Template Excel</button>
                        <button type="button" class="btn btn-success" ng-click="create()"><i class="fa fa-plus"></i> Thêm mới</button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <form class="form-horizontal">
                            <div class="col-md-1 col-md-offset-1">&nbsp;</div> 
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Từ khóa</label>
                                    <div class="col-md-8">
                                        <input class="form-control" type="text" ng-model="filters.url" ng-keypress="myEnter($event)" placeholder="https://example.com" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 text-center">
                                <button type="button" class="btn btn-primary" ng-click="filters.page_id = 0; find()"><i class="fa fa-search"></i> Tìm kiếm</button>
                                <button type="button" class="btn btn-default" ng-click="filters = { page_id: 0 }; find()"><i class="fa fa-times"></i> Xóa form</button>
                            </div>
                        </form>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                                <tr>
                                    <th style="width: 5%">#</th>
                                    <th class="col-sm-4">URL</th>
                                    <th class="col-sm-6">Hreflang</th>
                                    <th class="col-sm-2">Action</th>
                                </tr>
                                
                                <tr ng-repeat="item in items track by $index">
                                    <td>@{{ $index +1 }}</td>
                                    <td>
                                        <a ng-href="@{{ item.url }}" target="_blank" ng-bind="item.url"></a>
                                    </td>
                                    <td>
                                        <ul ng-if="item.content" style="margin-left: 10px">
                                            <li ng-repeat="(key, value) in item.content" style="list-style-type: disclosure-closed; margin-bottom: 10px">
                                                <span style="display: inline-block; width: 30px" ng-bind="(key | uppercase) + ':'"></span><a ng-href="@{{ value }}" target="_blank" ng-bind="value"></a>
                                            </li>
                                        </ul>
                                    </td>
                                    <td align="center">
                                        <button class="btn btn-primary" role="button" ng-click="edit(item)">
                                            <i class="fa fa-pencil" aria-hidden="true"></i>
                                        </button>
                                        <button class="btn btn-danger" role="button" ng-click="delete(item, $index)">
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr ng-if="items.length == 0">
                                    <td colspan="4">Không tìm thấy dữ liệu...</td>
                                </tr>
                        </table>
                    </div>

                    @view('system.seo.includes.paginator', [
                        "accessPageId" => "filters.page_id",
                        "accessPagesCount" => "pagesCount",
                        "accessFind" => "find()"
                    ])
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modal-hreflang" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" ng-disabled="isSaving">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" ng-bind="item.id ? 'Chỉnh sửa' : 'Thêm mới'"></h4>
                </div>
                <div class="modal-body">
                    <div class="row" ng-repeat="(key, value) in item.content">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="input-group">
                                    <span class="input-group-addon" ng-bind="(key | uppercase)" style="min-width: 45px"></span>
                                    <input type="text" class="form-control" placeholder="https://example.com" ng-model="item.content[key]">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" ng-click="save()" ng-disabled="isSaving">Lưu lại</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal" ng-disabled="isSaving">Đóng</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
<script type="text/javascript">
    const CURRENT_LOCALE = '{{ env('APP_LOCALE') }}';
</script>
<script src="/modules/seo/js/hreflang.module.controller.js?v={{ config('app.version') }}"></script>
@endsection
