<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <script>
        var contentEditor = {
            faq: {
                question: "",
                answer: ""
            },
            output: [],
        };
        if (typeof top.tinymce != "undefined")
            contentEditor = top.tinymce.activeEditor.windowManager.getParams();
    </script>
    <script src="/modules/seo/js/tinymce-4.9.4/tinymce.min.js?v=<?= Config::get("sa.version") ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <style>
        fieldset.scheduler-border {
            border: 1px dashed #dedede !important;
            margin: 0 0 1.5em 0 !important;
            -webkit-box-shadow: 0 0 0 0 #000;
            box-shadow: 0 0 0 0 #000;
            position: relative;
        }

        .form-control {
            width: 100%;
        }
    </style>
</head>
<body>
<div id="faqs">
    <fieldset class="scheduler-border">
        <table style="width: 100%;">
            <tr>
                <td><label for="fname">Question:</label></td>
                <td>
                    <textarea id="faq-question" rows="3" class="form-control faq"></textarea>
                </td>
            </tr>
            <tr>
                <td><label for="fname">Answer:</label></td>
                <td>
                    <textarea id="faq-answer" rows="3" class="form-control faq"></textarea>
                </td>
            </tr>
        </table>
    </fieldset>
</div>

<script>
    $(document).ready(() => {
        tinymce.init({
            selector: 'textarea#faq-question',
            height: 150,
            setup: (editor) => {
                editor.on('keyup', () => {
                    contentEditor.faq.question = editor.getContent();
                });
            }
        });
        tinymce.init({
            selector: 'textarea#faq-answer',
            height: 150,
            setup: (editor) => {
                editor.on('keyup', () => {
                    contentEditor.faq.answer = editor.getContent();
                });
            }
        });
    })
</script>
</body>
</html>
