@extends('system.layout.main', [
'ngController' => 'MetaDataController'
])
@section('title')
<title>Cấu hình Meta data</title>
@endsection

@section('content')
<section class="content" ng-cloak>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">Meta data List</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-primary" ng-click="getTemplate()"><i class="fa fa-file-excel-o"></i> Template Excel</button>
                        <button type="button" class="btn btn-primary" ngf-select ng-model="excelFile" ng-change="handleUpload(excelFile)" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" ngf-max-size="5MB" ><i class="fa fa-upload"></i> Import Excel</button>
                        <button type="button" class="btn btn-primary" ng-click="export()"><i class="fa fa-download"></i> Export Excel</button>
                        <button type="button" class="btn btn-success" ng-click="create()"><i class="fa fa-plus"></i> Add New</button>
                    </div>
                </div>
                <div class="box-body">
                    @view('system.meta-data.filters')
                    @view('system.meta-data.lists')
                    @include('seo::admin.meta-data.modal')
                    @view('system.seo.includes.paginator', [
                        "accessPageId" => "filter.page_id",
                        "accessPagesCount" => "pagesCount",
                        "accessFind" => "find()"
                    ])
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('script')
<script type="text/javascript">
    const CURRENT_LOCALE = '{{ env('APP_LOCALE') }}';
    let localesList = <?= json_encode(Config::get('localization::module.locales')) ?>;
</script>
<script src="/system/js/scripts/xlsx.full.min.js"></script>
<script src="/modules/seo/js/tinymce-4.9.4/tinymce.min.js?v=<?= Config::get("sa.version") ?>"></script>
<script src="/modules/seo/js/meta-data.module.controller.js?v={{ config('app.version') }}"></script>
@endsection
