<div class="modal fade" id="modalRedirect" role="dialog">
    <div class="modal-dialog" role="document" style="width: 80%">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span></button>
                <h4 class="modal-title">@{{ titleModal }}</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>URL:</label>
                            <input type="text" ng-model="metaData.url" placeholder="/clothing" class="form-control"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Canonical:</label>
                            <input type="text" ng-model="metaData.canonical" placeholder="https://example.com/abc" class="form-control"/>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Heading:</label>
                            <input type="text" ng-model="metaData.heading" class="form-control"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Meta title:</label>
                            <textarea ng-model="metaData.metaTitle" rows="2"  class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Meta Keywords:</label>
                            <textarea ng-model="metaData.metaKeywords" rows="2"  class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Meta Descriptions:</label>
                            <textarea ng-model="metaData.metaDescription" rows="2"  class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Content:</label>
                            <textarea rows="3" id="content" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Content footer:</label>
                            <textarea rows="3" id="content-footer" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="custom-control custom-checkbox">
                            <input class="custom-control-input" type="checkbox" ng-model="metaData.isGenerateContentFooter" checked="">
                            <label for="customCheckbox2" class="custom-control-label">Auto input content into the footer:</label>
                        </div>
                    </div>
                    <div class="col-md-12">
                        @view('trademark::check-trademark', [
                            'checkValue' => 'metaData',
                            'checkFields' => 'content,content_footer'
                        ])
                    </div>
                </div>
                <div class="rows">
                    <div class="col-md-12">
                        <p class="text-danger">@{{ failMessage }}</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" ng-click="save()" ng-disabled="isShowLoading">Save</button>
            </div>
        </div>
    </div>
</div>
