@extends('system.layout.main', [
'ngController' => 'OptionFilterLinkController'
])
@section('title')
<title>Cấu hình Link Tùy chọn trong Bộ lọc Danh mục</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-header">
                <div class="pull-left">
                    <h3>Custom link in category</h3>
                    <a ng-if="!uploading"
                       ngf-select="importFile($files)"
                       class="btn-upload-image">
                        <i class="fa fa-cloud-upload" aria-hidden="true"></i> Import
                    </a>
                </div>
                <div class="clearfix">
                </div>
            </div>
            <div class="box-body">
                <span ng-if="states.loading">Loading...</span>
                <table class="table table-bordered table-keyword-link" ng-show="!states.loading">
                    <tr>
                        <th>No.</th>
                        <th>Keyword</th>
                        <th>Title</th>
                        <th>URL</th>
                        <th>Category Name</th>
                        <th>
                            <button type="button" name="button" class="btn btn-success btn-flat add"
                                    style="border-radius: 5px; width: 100%;"
                                    id="btnSaveMap" ng-click="openEditForm(); mode = 'create'; status.is_changing_target = true;">
                                <i class="fa fa-plus"></i>  <span style="margin-left: 5px">Add New</span>
                            </button>
                        </th>
                    </tr>
                    <tr ng-repeat="link in links">
                        <td>@{{ link.id }}</td>
                        <td>@{{ link.keyword }}</td>
                        <td>@{{ link.title }}</td>
                        <td>
                            <a href="@{{ link.url }}" target="_blank">@{{ link.url }}</a>
                        </td>
                        <td>@{{ getCategory(link.target_id).name }}</td>
                        <td>
                            <span>
                                <button ng-click="openEditForm(link)" class="btn btn-primary">Edit</button>
                                <button ng-click="deleteLink(link)" class="btn btn-default">Delete</button>
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

@include('seo::admin.option-filter-link.modal')

@endsection

@section('script')
    <script src="/modules/seo/js/option-filter-link-controller.js"></script>
@endsection
@section('css')

@endsection