@extends('system.layout.main', [
'ngController' => 'RedirectController'
])
@section('title')
<title>Cấu hình Redirect</title>
@endsection

@section('content')
<section class="content" ng-cloak>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">List Redirect</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-primary" ngf-select ng-model="excelFile" ng-change="handleUpload(excelFile)" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" ngf-max-size="5MB" ><i class="fa fa-download"></i> Nhập Excel</button>
                        <button type="button" class="btn btn-primary" ng-click="export()"><i class="fa fa-upload"></i> Export Excel</button>
                        <button type="button" class="btn btn-success" ng-click="create()"><i class="fa fa-plus"></i> Add New</button>
                    </div>
                </div>
                <div class="box-body">
                    @view('system.redirect.filters')
                    @view('system.redirect.lists')
                    @view('system.redirect.modal')
                    @view('system.seo.includes.paginator', [
                        "accessPageId" => "filters.page_id",
                        "accessPagesCount" => "pagesCount",
                        "accessFind" => "find()"
                    ])
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('script')
<script type="text/javascript">
    const CURRENT_LOCALE = '{{ env('APP_LOCALE') }}';
    let localesList = <?= json_encode(Config::get('localization::module.locales')) ?>;
</script>
<script src="/modules/seo/js/redirect.module.controller.js?v={{ config('app.version') }}"></script>
@endsection
