<?php
    $pages = [
        'home' => "Homepage",
        'category' => "Category",
        'filter_category' => "Category Filters",
        'product' => "Product Detail",
        'params_product' => "Product Detail with Params",
        'tag' => "Tags",
        'search' => "Search",
        'seller' => "Seller",
        'news' => "Blog",
        'archive' => "Blog Category"
    ];
?>
@extends('system.layout.main', [
'ngController' => 'SeoController'
])

@section('title')
<title>Search Engine Optimization</title>
@endsection

@section('css')
<style media="screen">
    hr {
        border-top: 1px solid #ccc;
    }
</style>
@endsection


@section('content')
<div class="content" ng-cloak>
    <div class="header">
        <div class="pull-left">
            <h3>Config meta data</h3>
            <p>
                By default system had configured for title, meta title, meta description, ld json tags.
                <br>
                You can custom config meta title, meta description.
                By using variables: <b>{name}, {name_category}, {name_type}, {name_price}, {name_size}, {name_style}, {name_color}, {name_shop}, {name_brand}, {product_id}, {site_name}, {created_at}, {count}, {discount_percent}.</b>
            </p>
        </div>
        <button type="button" name="button" class="btn pull-right btn-success btn-flat" ng-click="save()">Save</button>

        <div class="clearfix"></div>
    </div>
    <br>
    <div class="body">
        <div class="row">
            @foreach ($pages as $key => $value)
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">{{ $value }}</h3>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <label for="{{ $key }}-title">Meta title</label>
                                <input id="{{ $key }}-title" type="text" value="" class="form-control " ng-model="{{ $key }}.title" >
                            </div>
                            <div class="form-group">
                                <label for="{{ $key }}-keywords">Meta keywords</label>
                                <input id="{{ $key }}-keywords" type="text" value="" class="form-control " ng-model="{{ $key }}.keywords" >
                            </div>
                            <div class="form-group">
                                <label for="{{ $key }}-description">Meta description</label>
                                <textarea id="{{ $key }}-description" rows="3" cols="80" class="form-control" ng-model="{{ $key }}.description">
                                </textarea>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
@endsection

@section('script')
<script type="text/javascript">
    system.controller("SeoController", SeoController);
    function SeoController($scope, $http, $rootScope, $interval, $window, Upload) {
        this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
        $scope.controllerName = "SeoController";

        $scope.init = async () => {
            @foreach ($pages as $key => $value)
                $scope.{{$key}} = await $scope.loadConfig('{{$key}}');
            @endforeach
        }

        $scope.loadConfig = (key) => {
            return new Promise((resolve, reject) => {
                $http({
                    method: 'get',
                    url: base_api_url + `/option?filters=key=${key}&metric=first`
                }).then(function success(response) {
                    if (response.data.status == 'successful') {
                        let configResponse = response.data.result;
                        if (configResponse && configResponse.value) {
                            resolve(JSON.parse(configResponse.value));
                        }
                    }
                    resolve(null);
                }).catch(function error() {
                    reject(null);
                })
            })
        }

        $scope.save = function() {
            $http.put(base_api_url + '/option/bulk', {
                @foreach ($pages as $key => $value)
                    '{{$key}}' : JSON.stringify($scope.{{$key}}),
                @endforeach
            }).then(
                function (response) {
                    toastr.success("Save successfuly.");
                },
                function (response) {
                    toastr.error("You have encountered an error. Please try again later.");
                }
            );
        }

        $scope.init();
    }
</script>
@endsection
