@extends('system.layout.main', [
'ngController' => 'SeoController'
])
@section('title')
<title>Search Engine Optimization</title>
@endsection
@section('css')
<style media="screen">
    hr {
        border-top: 1px solid #ccc;
    }
</style>
@endsection
@section('script')
<script type="text/javascript">

    var sitemapUrl = '{{ $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]/sitemap.xml" }}';

    system.controller("SeoController", SeoController);
    function SeoController($scope, $http, $rootScope, $interval, $window, Upload) {
        this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
        $scope.controllerName = "SeoController";

        $scope.init = async () => {
            $scope.googleTrackingId = await $scope.loadConfig("googleTrackingId");
            $scope.googleTrackingCode = await $scope.loadConfig("googleTrackingCode");
            $scope.googleSiteVerification = await $scope.loadConfig("googleSiteVerification");
        }

        $scope.generateTrackingCode = function() {
            if ($scope.googleTrackingId) {
                $scope.googleTrackingCode =
                    `<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=${$scope.googleTrackingId}"><\/script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', '${$scope.googleTrackingId}');
<\/script>`;
            } else {
                $scope.googleTrackingCode = "";
            }
        }

        $scope.loadConfig = (key) => {
            return new Promise((resolve, reject) => {
                $http({
                    method: 'get',
                    url: base_api_url + `/option?filters=key=${key}&metric=first`
                }).then(function success(response) {
                    if (response.data.status == 'successful') {
                        let configResponse = response.data.result;
                        if (configResponse && configResponse.value) {
                            resolve(JSON.parse(configResponse.value));
                        }
                    }
                    resolve(null);
                }).catch((err) => {
                    resolve(null);
                })
            })
        }

        $scope.save = function() {
            $http.put(base_api_url + '/option/bulk', {
                googleTrackingId: $scope.googleTrackingId,
                googleTrackingCode: $scope.googleTrackingCode,
                googleSiteVerification: $scope.googleSiteVerification,
            }).then(
                function success(response) {
                    console.log(response)
                    toastr.success("Đã lưu thành công");
                },
                function error(response) {
                    toastr.error("Không lưu được cấu hình. Vui lòng liên hệ bộ phận kỹ thuật.");
                }
            );
        }

        $scope.pingSiteMap = function() {
            $http.get('/seo/sitemap/ping?url=' + sitemapUrl).then(
                function success(response) {
                    if(response.data.status == 'successful')
                        toastr.success("Ping sitemap thành công!");
                    else {
                        toastr.warning("Có gì đó không đúng! Vui lòng thử lại sau!");
                    }
                },
                function error(response) {
                    toastr.error("Không ping được sitemap vui lòng thử lại sau!");
                }
            );
        }

        $scope.init();
    }

</script>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="header">
        <div class="pull-left">
            <h3 class="">Search Engine Optimization</h3>
        </div>
        <div class="clearfix">
        </div>
    </div>
    <br>
    <div class="body">
        <div class="row">
            <div class="col-md-3 visible-md visible-lg">
                * Nhập mã Google Analytics ID, mã tracking code sẽ tự động sinh ra.
                <br>
                Trong trường hợp muốn sử dụng mã tracking tùy chọn, vui lòng copy mã vào mã nhúng và bấm lưu.
            </div>
            <div class="col-md-9 col-sm-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Google Analytics</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="gtag">Google Analytics ID</label>
                            <input id="gtag" type="text" name="" value="" class="form-control " ng-model="googleTrackingId" ng-change="generateTrackingCode()">
                        </div>
                        <div class="form-group">
                            <label for="gtag-code">Mã nhúng</label>
                            <textarea id="gtag-code" name="name" rows="8" cols="80" class="form-control" ng-model="googleTrackingCode">
                            </textarea>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary" ng-click="save()">Lưu</button>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-md-3 visible-md visible-lg">
                * Để xác nhận Google Webmastertool, bạn có thể xác nhận bằng mã Google Analytics phía trên.
                <br>
                * Hoặc có thể chèn mã HTML meta tag tại đây.
            </div>
            <div class="col-md-9 col-sm-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Google Webmastertool</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <label for="gtag">HTML tag</label>
                            <input id="gtagverify" type="text" name="" value="" class="form-control " ng-model="googleSiteVerification">
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button ty pe="submit" class="btn btn-primary" ng-click="save()">Lưu</button>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-md-3 visible-md visible-lg">
                * Sitemap
                <br>
                Sitemap sẽ được generate tự động tại link sau đây
                Ngoài ra, hệ thống sẽ tự Ping đến Search Engine để tự động update nội dung.
            </div>
            <div class="col-md-9 col-sm-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Sitemap</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <div class="box-body">
                        <div class="form-group">
                            <input id="sitemap" type="text" name="" value="{{ $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]/sitemap.xml" }}" class="form-control" disabled>
                        </div>
                        <div class="form-group">
                            <input id="robots" type="text" name="" value="{{ $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]/robots.txt" }}" class="form-control" disabled>
                        </div>
                        <button ng-click="pingSiteMap()" class="btn btn-success">Ping sitemap</button>
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
        </div>
        <hr>
        
    </div>
</div>
@endsection
