@extends('system.layout.main', [
'ngController' => 'TextLinkFooterController'
])
@section('title')
<title>Cấu hình Text Link Footer</title>
@endsection

@section('content')
<section class="content" ng-cloak>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">Danh sách Text Link Footer</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-primary" ngf-select ng-model="excelFile" ng-change="handleUpload(excelFile)" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" ngf-max-size="5MB" ><i class="fa fa-upload"></i> Nhập Excel</button>
                        <button type="button" class="btn btn-primary" ng-click="downloadTemplate()"><i class="fa fa-file-excel-o"></i> Template Excel</button>
                        <button type="button" class="btn btn-success" ng-click="create()"><i class="fa fa-plus"></i> Thêm mới</button>
                    </div>
                </div>
                <div class="box-body">

                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                                <tr>
                                    <th style="width: 5%">#</th>
                                    <th class="col-sm-4">Name</th>
                                    <th class="col-sm-6">URL</th>
                                    <th class="col-sm-4ß">Action</th>
                                </tr>
                                
                                <tr ng-repeat="item in items track by $index">
                                    <td>@{{ $index +1 }}</td>
                                    <td>
                                        <span ng-bind="item.name"></span>
                                    </td>
                                    <td>
                                        <a ng-href="@{{ item.url }}" target="_blank" ng-bind="item.url"></a>
                                    </td>
                                    <td>
                                        <button class="btn btn-primary" role="button" ng-click="edit(item, $index)">
                                            <i class="fa fa-pencil" aria-hidden="true"></i>
                                        </button>
                                        <button class="btn btn-danger" role="button" ng-click="delete(item, $index)">
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr ng-if="items.length == 0">
                                    <td colspan="4">Không tìm thấy dữ liệu...</td>
                                </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modal-text-link-footer" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" ng-disabled="isSaving">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" ng-bind="type == 'update' ? 'Chỉnh sửa' : 'Thêm mới'"></h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="col-form-label">Name:</label>
                                <input type="text" class="form-control" ng-model="item.name">
                            </div>
                            <div class="form-group">
                                <label class="col-form-label">Url:</label>
                                <input type="text" class="form-control" ng-model="item.url">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" ng-click="save()" ng-disabled="isSaving">Lưu lại</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal" ng-disabled="isSaving">Đóng</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
<script src="/modules/seo/js/text-link-footer.module.controller.js?v={{ config('app.version') }}"></script>
@endsection
