@extends('system.layout.main')
@section('title')
    <title>Index Links</title>
@endsection
@section('css')

@endsection
@section('script')

@endsection
@section('content')

    <div class="content" ng-cloak>
        <h3>Google Index Tool</h3>
        <div class="box no-border">
            <div class="box-body">

                <form class="form" action="" method="post">
                    <div class="form-group">
                        <textarea name="link" class="form-control" placeholder="Enter Link" required cols="30" rows="10"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary"><strong>Push Index</strong></button>
                </form>

                <br>
                @foreach($msg as $m)
                <div class="text-{{ $m['class'] }}">{!! $m['text'] !!}</div>
                @endforeach
                <br>

                <table class="table">
                    <thead>
                    <tr>
                        <th>Link</th>
                        <th>Push At</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($googleIndexs as $index)
                        <tr>
                            <td>
                                <a target="_blank" href="{{ $index->url }}">{{ $index->url }}</a>
                            </td>
                            <td>{{ $index->created_at }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

                {{ $googleIndexs->links() }}

            </div>
        </div>
    </div>

@endsection
