@extends('layouts.master')
@section('css')
    <link rel="stylesheet" href="{{ Module::asset('seo/css/rss.css?v=' . config('app.version') ) }}">
@endsection
@section('main')

    <main class="main-content site-w">
        <div class="page-wrapper">
            <h1 class="blog-heading text-center">
                {{ getOption('general.store_name', 'Printerval') }} RSS
            </h1>
            <div class="rss-box-container">
                <h2 class="rss-header">
                    {{ $title }}
                </h2>
                <ul class="list-rss">
                    @foreach ($rss as $item)
                    <li class="rss-item">
                        <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                        <a class="rss-link" target="_blank" href="{{ route($rssXmlRoute, ['slug' => $item['slug']]) }}">{{ $item['name'] }}</a>
                    </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </main>
@endsection
