@extends('layouts.master')
@section('css')
<link rel="stylesheet" href="{{ Module::asset('seo/css/rss.css?v=' . config('app.version') ) }}">
@endsection
@section('main')

<main class="main-content site-w">
    <div class="page-wrapper">
        <h1 class="blog-heading">
            {{ getOption('general.store_name', 'Printerval') }} RSS
        </h1>
        <div class="rss-box-container">
            <div class="rss-header">
                {{ __('Home') }}
            </div>
            <ul class="list-rss">
                <li class="rss-item rss-item-header">
                    <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                    <a class="rss-link" target="_blank" href="{{ route('seo::rss::home') }}">Home</a>
                </li>
            </ul>
        </div>
        @isset($rss_categories)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('Categories') }}
                </div>
                <ul class="list-rss">
                    @foreach ($rss_categories as $item)
                    <li class="rss-item">
                        @if ($item['name'])
                            <div class="rss-item-header">
                                <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                <a class="rss-link" target="_blank" href="{{ route('seo::rss::category', ['slug' => $item['slug']]) }}">{{ $item['name'] }}</a>
                                @if (isset($item->childCates) && count($item->childCates) > 0)
                                <span class="toggle-button">
                                    <img src="{{ Module::asset('seo/images/down.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16">
                                </span>
                                @endif
                            </div>
                            @if (isset($item->childCates) && count($item->childCates) > 0)
                            <ul class="rss-sub-list">
                                @foreach ($item->childCates as $child)
                                <li class="rss-sub-item">
                                    <div class="rss-sub-item-header">
                                        <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                        <a class="rss-link" target="_blank" href="{{ route('seo::rss::category', ['slug' => $child['slug']]) }}">{{ $child['name'] }}</a>
                                    </div>
                                    @if (isset($child['smaller_categories']) && count(isset($child['smaller_categories'])) > 0)
                                    <ul class="rss-sub-children-list">
                                        @foreach ($child['smaller_categories'] as $smallCategory)
                                        <li class="rss-sub-children-item">
                                            <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                            <a class="rss-link" target="_blank" href="{{ route('seo::rss::category', ['slug' => $smallCategory['slug']]) }}">{{ $smallCategory['name'] }}</a>
                                        </li>
                                        @endforeach
                                    </ul>
                                    @endif
                                </li>
                                @endforeach
                            </ul>
                            @endif
                        @endif
                    </li>
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($rss_products)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('Products') }}
                </div>
                <ul class="list-rss">
                    @foreach ($rss_products as $idx => $item)
                    <li class="rss-item rss-item-header">
                        <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                        <a class="rss-link" target="_blank" href="{{ route('seo::rss::product', ['slug' => $item]) }}">{{ __('New Product') . ' ' . ($idx + 1) }}</a>
                    </li>
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($rss_tags)
            <div class="rss-box-container">
            <div class="rss-header">{{ __('Tags') }}</div>
            <div class="rss-list-tags">
                @foreach ($rss_tags as $tag)
                    <a class="rss-tag-item-link" href="{{ route('seo::rss::tag', ['slug' => $tag->slug]) }}">
                        {{ __($tag->title) }}
                    </a>
                @endforeach
            </div>
            <div class="more-rss-tag">
                <span class="more-tag">More tags</span>
                <span class="less-tag">Less</span>
            </div>
            </div>
        @endisset

        @isset($rss_pages)
            <div class="rss-box-container">
                <div class="rss-header">{{ __('Pages') }}</div>
                <ul class="list-rss">
                    @foreach ($rss_pages as $page)
                        @if ($page['title'])
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/star.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('seo::rss::page', ['slug' => $page['slug']]) }}">{{ __($page['title']) }}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($rss_shops)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('Shops') }}
                </div>
                <ul class="list-rss">
                    @foreach ($rss_shops as $shop)
                        @if ($shop->seller_name)
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/store.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('seo::rss::shop', ['slug' => $shop->seller_slug]) }}">{{ __($shop->seller_name) }}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($rss_posts_categories)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('News Category') }}
                </div>
                <ul class="list-rss">
                    <li class="rss-item">
                        <div class="rss-item-header">
                            <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                            <a class="rss-link" target="_blank" href="{{ route('seo::rss::news', ['slug' => 'all-news']) }}"> {{ __('News') }} </a>
                        </div>
                    </li>
                    @foreach ($rss_posts_categories as $posts_category)
                        @if ($posts_category->name)
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/rss.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('seo::rss::news', ['slug' => $posts_category->slug]) }}">{{ $posts_category->name }}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset
    </div>
</main>
@endsection
@section('js')
@parent
<script src="{{ Module::asset('seo/js/rss.js?v=' . config('app.version') ) }}"></script>
@endsection