@extends('layouts.master')
@section('css')
<link rel="stylesheet" href="{{ Module::asset('seo/css/rss.css?v=' . config('app.version') ) }}">
@endsection
@section('main')

<main class="main-content site-w">
    <div class="page-wrapper">
        <h1 class="blog-heading">
            {{ getOption('general.store_name', 'Printerval') }} Sitemap
        </h1>
        <div class="rss-box-container">
            <div class="rss-header">
                {{ __('Home') }}
            </div>
            <ul class="list-rss">
                <li class="rss-item rss-item-header">
                    <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/sitemap.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                    <a class="rss-link" target="_blank" href="{{ route('home') }}">Home</a>
                </li>
            </ul>
        </div>
        @isset($productCategories)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('Categories') }}
                </div>
                <ul class="list-rss">
                    @foreach ($productCategories as $item)
                    <li class="rss-item">
                        @if ($item['name'])
                            <div class="rss-item-header">
                                <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/sitemap.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                <a class="rss-link" target="_blank" href="{{ $item['url'] }}">{{ $item['name'] }}</a>
                                @if (isset($item['childs']) && count($item['childs']) > 0)
                                <span class="toggle-button">
                                    <img src="{{ Module::asset('seo/images/down.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16">
                                </span>
                                @endif
                            </div>
                            @if (isset($item['childs']) && count($item['childs']) > 0)
                            <ul class="rss-sub-list">
                                @foreach ($item['childs'] as $child)
                                <li class="rss-sub-item">
                                    <div class="rss-sub-item-header">
                                        <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/sitemap.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                        <a class="rss-link" target="_blank" href="{{ $child['url']  }}">{{ $child['name'] }}</a>
                                    </div>
                                    @if (isset($child['childs']) && count(isset($child['childs'])) > 0)
                                    <ul class="rss-sub-children-list">
                                        @foreach ($child['childs'] as $smallCategory)
                                        <li class="rss-sub-children-item">
                                            <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/sitemap.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                            <a class="rss-link" target="_blank" href="{{ $smallCategory['url'] }}">{{ $smallCategory['name'] }}</a>
                                        </li>
                                        @endforeach
                                    </ul>
                                    @endif
                                </li>
                                @endforeach
                            </ul>
                            @endif
                        @endif
                    </li>
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($newProducts)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('New Products') }}
                </div>
                <ul class="list-rss">
                    @foreach ($newProducts as $newProduct)
                        @if ($newProduct['name'])
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/product.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('product', ['slug' => $newProduct['slug'], 'id' => $newProduct['id']]) }}">{{ __($newProduct['name']) }}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($tags)
            <div class="rss-box-container">
            <div class="rss-header">{{ __('Tags') }}</div>
            <div class="rss-list-tags">
                @foreach ($tags as $tag)
                    @if ($tag['title'])
                        <a class="rss-tag-item-link" href="{{ clroute('/explore/'. $tag['slug']) }}">
                            {{ __($tag['title']) }}
                        </a>
                    @endif
                @endforeach
            </div>
            <div class="more-rss-tag">
                <span class="more-tag">More tags</span>
                <span class="less-tag">Less</span>
            </div>
            </div>
        @endisset

        @isset($landingPages)
            <div class="rss-box-container">
                <div class="rss-header">{{ __('Pages') }}</div>
                <ul class="list-rss">
                    @foreach ($landingPages as $page)
                        @if ($page['title'])
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/star.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('landing-page::landing-page', ['slug' => $page['slug']]) }}">{{ __($page['title']) }}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($postCategories)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('News Category') }}
                </div>
                <ul class="list-rss">
                    @foreach ($postCategories as $posts_category)
                        @if ($posts_category['name'])
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/sitemap.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('archive', ['slug' => $posts_category['slug'], 'id' => $posts_category['id']]) }}">{{ $posts_category['name']}}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset

        @isset($newPosts)
            <div class="rss-box-container">
                <div class="rss-header">
                    {{ __('New Posts') }}
                </div>
                <ul class="list-rss">
                    @foreach ($newPosts as $newPost)
                        @if ($newPost['name'])
                            <li class="rss-item">
                                <div class="rss-item-header">
                                    <img src="{{ Module::asset('seo/images/' . env('APP_NAME') .'/new.svg?v=' . config('app.version') ) }}" alt="@Printerval" width="16" height="16" class="rss-icon">
                                    <a class="rss-link" target="_blank" href="{{ route('post', ['slug' => $newPost['slug'], 'id' => $newPost['id']]) }}">{{ __($newPost['name']) }}</a>
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>
        @endisset

    </div>
</main>
@endsection
@section('js')
@parent
<script src="{{ Module::asset('seo/js/rss.js?v=' . config('app.version') ) }}"></script>
@endsection