<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:news="http://www.google.com/schemas/sitemap-news/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1" xmlns:xhtml="http://www.w3.org/1999/xhtml">
    @foreach ($items as $item)
    <url>
        <loc>{{ $item['url'] }}</loc>
        <news:news>
            <news:publication>
                <news:name>{{ env('APP_NAME') }}</news:name>
                <news:language>{{ $item['lang'] }}</news:language>
            </news:publication>
            <news:publication_date>{{ date('c', $item['created_at']) }}</news:publication_date>
            <news:title>{{ $item['name'] }}</news:title>
        </news:news>
        @if (!empty($item['image_url']))
        <image:image>
            <image:loc>{{ getImageCdn($item['image_url'], 540, 540, true, false) }}</image:loc>
            <image:title>{{ $item['name'] }}</image:title>
        </image:image>
        @endif
        @if(!empty($item['hreflangs']))
            @foreach ($item['hreflangs'] as $href)
                <xhtml:link rel="alternate" hreflang="{{ $href['lang'] }}" href="{{ $href['url'] }}" />
            @endforeach
        @endif
    </url>
    @endforeach
</urlset>