<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
use Illuminate\Support\Facades\Config;

Route::group(['prefix' => 'seo', 'middleware' => 'example'], function () {

    Route::get('/sitemap/ping', [ 'as' => 'seo::pingSitemap', 'uses' => 'SeoController@pingSiteMap' ]);
    Route::get('/rss/generate', [ 'as' => 'seo::generateRss', 'uses' => 'SeoController@generateRss' ]);

    Route::group(['prefix' => 'autolink-keywords'], function () {
        Route::get('/', 'SeoAutoLinkController@index')->name('seo::keywordlink::manager');
        Route::post('/store', 'SeoAutoLinkController@storeKeywordLinks');
        Route::post('/import', 'SeoAutoLinkController@import');
        Route::any('/autolink', 'SeoAutoLinkController@autoLink');
        Route::any('/trigger', 'SeoAutoLinkController@triggerAutoLink');
    });

    Route::group(['prefix' => 'autolink-v2'], function () {

        Route::any('/autolink', 'AutoLinkController@runAutoLink');
        Route::any('/trigger', 'AutoLinkController@triggerAutoLink');
        Route::any('/test-auto-function', 'AutoLinkController@testAutoFunction');

    });

});

Route::get('/robots.txt', 'SeoController@getRobotsTxt')->name('robotsTxt');
Route::get('/seo/bing-submit', 'BingController@cronSubmitUrl');
Route::get('/seo/bing-quota', 'BingController@getUrlQuota');
Route::get('/sitemap', 'SitemapController@list');

Route::middleware(config('app.system_auth_middleware'))->prefix('manage')->group(function (){

    Route::get('/seo/setting', 'IndexController@setting')->name('seo::admin::setting');
    Route::get('/seo/setting-meta', 'IndexController@settingMeta')->name('seo::admin::setting-meta');
    Route::get('/seo/redirect', 'IndexController@redirect')->name('seo::admin::redirect');
    Route::get('/seo/meta-data', 'IndexController@metaData')->name('seo::admin::meta-data');
    Route::get('/seo/tag/config', 'IndexController@tagConfig')->name('seo::admin::tag-config');
    Route::get('/seo/faq', 'IndexController@faq')->name('seo::admin::faq');
    Route::get('/seo/hreflang', 'IndexController@hreflang')->name('seo::admin::hreflang');
    Route::get('/seo/option-filter-link', 'IndexController@optionFilterLink')->name('seo::admin::option-filter-link');
    Route::post('/seo/import-option-link', 'OptionLinkController@import');
    Route::get('/seo/text-link-footer', 'TextLinkFooterController@index')->name('seo::admin::text-link-footer');
    Route::get('/seo/meta-data/dialog-faq', 'MetaDataController@dialogFaq')->name('seo::admin::meta-data-dialog-faq');
});

Route::group(['prefix' => 'seo/redirect', 'middleware' => 'web'], function () {
    Route::get('find', ['uses' => 'RedirectController@findRedirect']);
    Route::post('save', ['uses' => 'RedirectController@saveRedirect']);
    Route::post('import', ['uses' => 'RedirectController@importRedirect']);
    Route::post('delete', ['uses' => 'RedirectController@deleteRedirect']);
    Route::get('build', ['uses' => 'RedirectController@buildCacheRedirect']);
});

Route::group(['prefix' => 'seo/meta-data', 'middleware' => 'web'], function () {
    Route::get('find', ['uses' => 'MetaDataController@find']);
    Route::post('save', ['uses' => 'MetaDataController@save']);
    Route::patch('save/{id}', ['uses' => 'MetaDataController@save']);
    Route::post('import', ['uses' => 'MetaDataController@import']);
    Route::post('delete', ['uses' => 'MetaDataController@delete']);
});

Route::group(['prefix' => 'seo/hreflang', 'middleware' => 'web'], function () {
    Route::get('find', ['uses' => 'HreflangController@find']);
    Route::post('save', ['uses' => 'HreflangController@save']);
    Route::post('import', ['uses' => 'HreflangController@import']);
    Route::post('delete', ['uses' => 'HreflangController@delete']);
});

Route::group(['prefix' => 'seo/tag/config', 'middleware' => 'web'], function () {
    Route::post('find', ['uses' => 'TagConfigController@findTagConfig']);
    Route::post('save', ['uses' => 'TagConfigController@saveTagConfig']);
    Route::post('delete', ['uses' => 'TagConfigController@deleteTagConfig']);
    Route::get('build-image', ['uses' => 'TagConfigController@buildTagImage']);
});

Route::group(['prefix' => 'seo/faq', 'middleware' => 'web'], function () {
    Route::get('find', ['uses' => 'FaqController@find']);
    Route::post('save', ['uses' => 'FaqController@save']);
    Route::post('delete', ['uses' => 'FaqController@delete']);
});

Route::group(['prefix' => 'rss', 'middleware' => 'frontend'], function () {
    Route::any('/', [ 'as' => 'seo::rss', 'uses' => 'RssController@listRss', ]);
    Route::get('/home.xml', [ 'as' => 'seo::rss::home', 'uses' => 'RssController@showHomeRss', ]);
    Route::get('/category/{slug}.xml', [ 'as' => 'seo::rss::category', 'uses' => 'RssController@showCategoryRss', ]);
    Route::get('/explore/{slug}.xml', [ 'as' => 'seo::rss::tag', 'uses' => 'RssController@showTagRss', ]);
    Route::get('/shop/{slug}.xml', [ 'as' => 'seo::rss::shop', 'uses' => 'RssController@showShopRss', ]);
    Route::get('/news/{slug}.xml', [ 'as' => 'seo::rss::news', 'uses' => 'RssController@showNewsRss', ]);
    Route::get('/page/{slug}.xml', [ 'as' => 'seo::rss::page', 'uses' => 'RssController@showPageRss', ]);
    Route::get('/product/{slug}.xml', [ 'as' => 'seo::rss::product', 'uses' => 'RssController@showProductRss', ]);
    Route::any('/build-all', ['uses' => 'RssController@buildAllRss',]);
    Route::get('/{category_slug}/{tag_slug}', [ 'uses' => 'RssController@getTagRssByCategory', 'as' => 'seo::rss::tag_by_category', ]);
});

Route::group(['prefix' => 'seo/text-link-footer', 'middleware' => 'web'], function () {
    Route::get('find', ['uses' => 'TextLinkFooterController@find']);
    Route::post('save', ['uses' => 'TextLinkFooterController@save']);
    Route::post('import', ['uses' => 'TextLinkFooterController@import']);
});

Route::middleware(['web', 'frontend'])->group(function () {
    if (Config::get('seo::default.allow_redirect', true)) {
        Route::get('{slug}/{slug2?}/{slug3?}/{slug4?}/{slug5?}/{slug6?}', [
            'uses' => 'UrlManagerController@resolve',
            'useCustomValidator' => true
        ])->name('categoryOrTag');
    }
});




