<?php

namespace Modules\SpreadsheetControl\Controllers;

use Illuminate\Http\Request;
use Modules\SpreadsheetControl\Controllers\Controller;
use Module;
use Config;
use DB;
use Google_Client;
use Google_Service_Sheets;
use Google_Service_Sheets_ClearValuesRequest;
use Google_Service_Sheets_ValueRange;
use Input;
use Log;
use Mail;
use Product;
use ProductPrice;
use Response;
use function base_path;
use ProductVariantService;

class SpreadsheetController extends Controller
{
    public function __construct()
    {        
        Module::onView("content", function() {
            return "This is content view from SpreadsheetControl Module HomeController";
        }, 5);
    }

    /**
     * @param array $input
     * authCode
     * @return Google_Client
     * @throws \Google\Exception
     */
    public function getClient($input = []) {
        $scopes = Google_Service_Sheets::SPREADSHEETS;
        if (isset($input['scopes'])){
            $scopes = $input['scopes'];
        }
        $client = new Google_Client();
        $client->setApplicationName("Client API");
        $client->setScopes($scopes);
        $authPath = isset($input['authPath'])?$input['authPath']:base_path().'/app/Modules/SpreadsheetControl/AuthConfig/auth.json';
        $client->setAuthConfig($authPath);
        $client->setAccessType('offline');

        // Load previously authorized credentials from a file.
        $credentialsPath = isset($input['credentialsPath'])?$input['credentialsPath']:base_path().'/app/Modules/SpreadsheetControl/AuthConfig/credentials.json';
        if (file_exists($credentialsPath)) {
            $accessToken = json_decode(file_get_contents($credentialsPath), true);
        } else {
            // Request authorization from the user.
            $authUrl = $client->createAuthUrl();
            printf("Open the following link in your browser:\n%s\n", $authUrl);
            print 'Enter verification code: ';
            $authCode = trim($input['authCode']);

            // Exchange authorization code for an access token.
            $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);

            // Store the credentials to disk.
            if (!file_exists(dirname($credentialsPath))) {
                mkdir(dirname($credentialsPath), 0700, true);
            }
            file_put_contents($credentialsPath, json_encode($accessToken));
            printf("Credentials saved to %s\n", $credentialsPath);
        }
        $client->setAccessToken($accessToken);

        // Refresh the token if it's expired.
        if ($client->isAccessTokenExpired()) {
            $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            file_put_contents($credentialsPath, json_encode($client->getAccessToken()));
        }
        return $client;
    }

    /**
     * @param array $input
     * $values, $range, $spreadsheetId, $authCode
     * @return mixed
     */
    public function pushToSheet($input = []) {
        ini_set("memory_limit", "10240M");
        $countUpdated = 0;
        $values =  $input['values'];
        $count =  count($values);
        try {
            $client = $this->getClient($input['authCode']);
            $service = new Google_Service_Sheets($client);
            $params = array(
//                'valueInputOption' => "USER_ENTERED",
                'valueInputOption' => "RAW",
//                'insertDataOption' => "OVERWRITE"
//                'insertDataOption' => "INSERT_ROWS"
            );
            $response = ["status" => "successful"];
            $requestBody = new Google_Service_Sheets_ClearValuesRequest();
            $service->spreadsheets_values->clear($input['spreadsheetId'], $input['range'], $requestBody);
            $length = 10000;
//            $body = new Google_Service_Sheets_ValueRange(array(
//                'values' => $values
//            ));
//            $result = $service->spreadsheets_values->update($input['spreadsheetId'], $input['range'], $body, $params);
//            $countUpdated += $result->getUpdatedRows();
            for ($i = 0; $i < $count; $i +=$length){
                $body = new Google_Service_Sheets_ValueRange(array(
                    'values' => array_slice($values, $i ,$length)
                ));
                $result = $service->spreadsheets_values->append($input['spreadsheetId'], $input['range'], $body, $params);
                $countUpdated += $result->getUpdates()->getUpdatedRows();
            }
            $response['count'] = $count;
        } catch (Exception $exc) {
            $response = ["status" => "fail", "message" => $exc->getMessage()];
        }
        $response['updated'] = $countUpdated;
        return response()->json($response);
    }

    public function updateSheet($input = []){
        $retVal = [];
        $values =  $input['values'];
        $count =  count($values);
        $client = $this->getClient($input['authCode']);
        $service = new Google_Service_Sheets($client);
        $params = array(
            'valueInputOption' => "RAW",
        );
        $requestBody = new Google_Service_Sheets_ClearValuesRequest();
        $service->spreadsheets_values->clear($input['spreadsheetId'], $input['range'], $requestBody);
        $body = new Google_Service_Sheets_ValueRange(array(
            'values' => $values
        ));
        $result = $service->spreadsheets_values->update($input['spreadsheetId'], $input['range'], $body, $params);
        $countUpdated = $result->getUpdatedRows();
        $retVal['count'] = $count;
        $retVal['updated'] = $countUpdated;
        return $retVal;
    }

    public function countRow($input = []){
        $client = $this->getClient($input['authCode']);
        $service = new Google_Service_Sheets($client);
        $result = $service->spreadsheets_values->get($input['spreadsheetId'], $input['range']);
        return $result->count();
    }
}
