<?php

namespace Modules\Subscription\Controllers;

use App\Mail\NewOrder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Modules\Subscription\Controllers\Controller;
use Module;
use Modules\Subscription\Models\Customer;
use Modules\Subscription\Models\Discount;
use Modules\Subscription\Models\Order;
use Modules\Subscription\Models\PromotionCode;
use Modules\Subscription\Models\Subscribe;

class HomeController extends Controller
{
    public function __construct()
    {        
        Module::onView("content", function() {
            return "This is content view from Subscription Module HomeController";
        }, 5);
    }
    public function index(Request $request)
    {
        $message = config("subscription::app.message");
        return view('subscription::home.welcome', [
            'message' => $message,
        ]);
    }

    public function store (Request $request) {
        $email = $request->input('email');
        $response = [
            'status' => 'fail',
            'message' => __('Something went wrong. Please try again later!')
        ];
        if ($email) {
            $checkExist = Subscribe::where('email', '=', $email)->exists();
            if (!$checkExist) {
                Subscribe::create(['email' => $email]);
                $configDiscount = getOption('subscription_percent_discount', 0);
                $maxDiscount = getOption('subscription_max_discount_value', 0);
                if ($configDiscount > 0 && $this->checkSendEmail($email)) {
                    $this->handleSendEmail($email, $configDiscount, $maxDiscount);
                }
                $response = [
                    'status' => 'successful',
                    'message' => 'Successful'
                ];
            } else {
                $response = [
                    'status' => 'fail',
                    'message' => __('Email already exists!')
                ];
            }
        }
        return response()->json($response);
    }

    private function checkSendEmail ($email) {
        $retVal = true;
        $customerIds = Customer::where('email', '=', $email)
            ->pluck('id')->toArray();
        if (count($customerIds) > 0) {
            $order = Order::whereIn('customer_id', $customerIds)
                ->whereNotIn('status', ['CANCELED', 'RETURNED'])
                ->first();
            if (!empty($order->id)) {
                $retVal = false;
            }
        }
        return $retVal;
    }

    private function handleSendEmail ($email, $configDiscount, $maxDiscount) {
        $code = PromotionCode::generateCode();
        $discount = Discount::create([
            'title' => 'Discount',
            'code' => $code,
            'status' => 'active',
            'type' => 'percent',
            'value' => $configDiscount,
            'max_discount_value' => $maxDiscount > 0 ? $maxDiscount : null,
            'limited_number_uses' => 1,
            'number_uses' => 0,
            'apply_type' => 'all',
            'start_time' => date('Y-m-d'),
            'end_time' => date('Y-m-d', strtotime('+7 days')),
            'created_at' => date('Y-m-d'),
            'updated_at' => date('Y-m-d'),
            'minimum_require_type' => 'none',
            'minimum_require_value' => null,
        ]);
        Mail::to($email)->send(new \Modules\Subscription\Mail\PromotionCode($discount));
    }
}
