<?php

namespace Modules\Subscription\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Modules\Subscription\Models\Option;

class PromotionCode extends Mailable
{
    use Queueable, SerializesModels;

    public $discount;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($discount)
    {
        $this->discount = $discount;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $siteName = config('app.name');
        return($this->subject($siteName . ' ' . translate('Exclusive ' . $this->discount->value . '% Discount'))
                        ->view('subscription::email', [
                            'storeName' => $siteName,
                            'discount' => $this->discount
                        ]));
    }

}
