<?php

namespace Modules\Subscription\Models;
use Illuminate\Database\Eloquent\Model;

class PromotionCode extends Model
{
    protected $table = "promotion_code";

    protected $fillable = [
        'code',
        'status',
        'discount',
        'discount_percent',
        'max_discount',
        'limit_number',
        'used_number',
        'category_id',
        'min_amount',
        'expired_at',
    ];

    public static function generateCode () {
        $checkCodePromotion = false;
        do {
            $randomString = self::randomStringPromotionCode(15);

            if (!PromotionCode::where('code', '=', $randomString)->exists()) {
                $checkCodePromotion = true;
            }
        } while ($checkCodePromotion == false);
        return $randomString;
    }

    protected static function randomStringPromotionCode($length = 10) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

}
