document.addEventListener("DOMContentLoaded", function (event) {
    var exitIntentIsTriggered = false;
    const ExitIntentCookieService = {
        setCookie(name, value, days) {
            let expires = '';
            if (days) {
                const date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = '; expires=' + date.toUTCString();
            }
            document.cookie = name + '=' + (value || '') + expires + ';';
        },
        getCookie(name) {
            const cookies = document.cookie.split(';');
            for (const cookie of cookies) {
                if (cookie.indexOf(name + '=') > -1) {
                    return cookie.split('=')[1];
                }
            }
            return null;
        }
    }

    function desktopExitIntent() {
        let last_position = {};
        window.addEventListener('mousemove', event => {
            if (typeof (last_position.x) != 'undefined') {
                let deltaX = last_position.x - event.offsetX,
                    deltaY = last_position.y - event.offsetY;

                if (Math.abs(deltaY) > Math.abs(deltaX) && deltaY > 0) {
                    //upward movement
                    var formInvalid = false;
                    /* $('#name, #phone, #email').each(function () {
                        if ($(this).val() === '') {
                            formInvalid = true;
                        }
                    }); */
                    if (event.clientY <= 4 && !formInvalid) {
                        showExitPopup();
                    }
                }
            }
            last_position = {
                x: event.offsetX,
                y: event.offsetY
            };
        });
    }

    function mobileExitIntent() {
        jQuery(document).on('scroll', function () {
            var formInvalid = false;
            /* $('#name, #phone, #email').each(function () {
                if ($(this).val() === '') {
                    formInvalid = true;
                }
            }); */
            if (get_my_scroll() < -50 && !formInvalid) {
                showExitPopup();
            }
        });
    }

    var get_my_scroll = (function () {
        let last_position, new_position, timer, delta, delay = 50;
        function clear() {
            last_position = null;
            delta = 0;
        }
        clear();
        return function () {
            new_position = window.scrollY;
            if (last_position != null) {
                delta = new_position - last_position;
            }
            last_position = new_position;
            clearTimeout(timer);
            timer = setTimeout(clear, delay);
            return delta;
        };
    })();

    // user action
    setTimeout(() => {
        if (!ExitIntentCookieService.getCookie('exitIntentShown') && exitIntentRouteName == 'module::cart::checkout') {
            desktopExitIntent();
            mobileExitIntent();
        }
    }, 1);

    // route step
    var supportsTouch = 'ontouchstart' in window || navigator.msMaxTouchPoints;
    if (!ExitIntentCookieService.getCookie('exitIntentShown') && supportsTouch === true) {
        try {
            const referrer = new URL(document.referrer);
            if (referrer.hostname && referrer.hostname != location.hostname) { // đi từ ngoài vào
                document.cookie = "outterRefer=" + referrer.hostname + ";";
            }

            if (ExitIntentCookieService.getCookie('outterRefer') && referrer.hostname == location.hostname) {
                let step = (ExitIntentCookieService.getCookie('innerStep')) ? ExitIntentCookieService.getCookie('innerStep') : 0;
                step = parseInt(step) + 1;
                document.cookie = "innerStep=" + step + ";";
            }

            if (ExitIntentCookieService.getCookie('outterRefer') && ExitIntentCookieService.getCookie('innerStep')) {
                let step = ExitIntentCookieService.getCookie('innerStep');
                let refer = ExitIntentCookieService.getCookie('outterRefer');
                step = parseInt(step);
                if (step >= 3 && refer == referrer.hostname) {
                    showExitPopup();
                }
            }

        } catch (error) {
            console.warn(error);
        }
    }

    function showExitPopup() {
        if(!exitIntentIsTriggered) {
            $('.exit-popup').fadeIn();
            ExitIntentCookieService.setCookie('exitIntentShown', true, 30);
            exitIntentIsTriggered = true;
        }
    }

    function exitIntentvalidateEmail(email) {
        const re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(String(email).toLowerCase());
    }

    $(document).on('click', '.close-exit-popup', function () {
        $('.exit-popup').fadeOut(100);
    });

    $(document).on('click', '#exit-popup-form-submit', function () {
        let text = $('#exit-popup-form-text').val();
        let email = $('#exit-popup-form-email').val();

        if (text && email && exitIntentvalidateEmail(email)) {
            postExitPopupForm(text, email);
        } else {
            $('#exit-popup-form-error-text').show();
            setTimeout(() => {
                $('#exit-popup-form-error-text').fadeOut();
            }, 3000);
        }
    });

    function postExitPopupForm(text, email) {

        $('#exit-popup-form-submit').css('opacity', 0.5);
        $('#exit-popup-form-submit').attr('disabled', 'true');

        var data = JSON.stringify({
            "token_customer": btoa(email),
            "token_ticket": btoa(email + Math.floor(Date.now() / 1000)),
            "title": "Exit popup proposal",
            "email": email,
            "content": text,
            "files": "[]",
            "status": "open",
            "type": "complaint",
            "customer_name": email
        });
        

        var xhr = new XMLHttpRequest();
        xhr.addEventListener("readystatechange", function () {
            if (this.readyState === 4) {

                $('#exit-popup-form-submit').removeAttr('disabled');
                $('#exit-popup-form-submit').css('opacity', 1);

                let responseText = JSON.parse(this.responseText);
                if(responseText.status == 'successful') {
                    $('.exit-popup-input').hide();
                    $('.exit-popup-success').show();
                    setTimeout(() => {
                        $('.exit-popup').fadeOut(100);
                    }, 2500);
                }
            }
        });

        xhr.open("POST", "/ticket/send");
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.send(data);

        xhr = new XMLHttpRequest();
        xhr.addEventListener("readystatechange", function () {});
        xhr.open("POST", "/subscription");
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.send(JSON.stringify({
            email: email
        }));
        
    }


});