<div class="exit-popup">
    <style type="text/css">
        .exit-popup {
            width: 100%;
            height: 100%;
            z-index: 234;
            display: none;
            justify-content: center;
            position: fixed;
            top: 0;
            left: 0
        }

        .exit-popup-background {
            width: 100%;
            height: 100%;
            z-index: 2;
            display: flex;
            background-color: rgba(11, 11, 11, 0.5);
            position: absolute;
            top: 0;
            left: 0
        }

        .exit-popup-content {
            width: 90%;
            max-width: 460px;
            max-height: 90vh;
            margin: 7vh auto 7vh;
            position: relative;
            z-index: 3;
            background-color: #fff;
            border-radius: 4px;
            padding: 8px 16px;
            position: relative
        }

        .exit-popup-image::before {
            content: "";
            width: 100%;
            height: 206px;
            display: block;
            position: absolute;
            top: 0;
            left: 0;
            background: #69d9ff;
            border-radius: 4px 4px 0 0
        }

        .exit-popup-image img {
            position: relative;
            z-index: 2
        }

        .exit-popup-image {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 220px
        }

        .exit-popup .exit-popup-form {
            margin: 10px 0
        }

        .form-control {
            font-size: .85rem;
            resize: none
        }

        .exit-popup-header {
            font-weight: 500;
            text-align: center;
            font-size: 1.25rem
        }

        .exit-popup-info {
            font-size: .9rem;
            text-align: center
        }

        .exit-popup-close {
            width: 40px;
            height: 40px;
            position: absolute;
            top: 0;
            right: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            color: rgba(255, 255, 255, 0.7);
            cursor: pointer
        }

        .exit-popup-close:hover {
            color: #fff
        }

        .email-submit {
            border-radius: 32px;
            padding-left: 24px;
            padding-right: 24px;
            margin: 10px auto 6px
        }

    </style>
    <div class="exit-popup-content">
        <div class="exit-popup-image">
            <img src="{{ asset('modules/subscription/images/exit-picture.png') }}" alt="" width="200">
        </div>
        <div class="exit-popup-header">
            {{ __('Elevate Your Performance') }}
        </div>
        <div class="exit-popup-info">
            {{ __('Your custom proposal will have: competitor research, specific ideas, and custom pricing.') }}
        </div>
        <form class="exit-popup-form exit-popup-input" method="post">
            <textarea id="exit-popup-form-text" rows="2" class="form-control"
                placeholder="{{ __('How can we help you? Anything unclear about our product or webiste?') }}"></textarea>
            <input id="exit-popup-form-email" class="form-control" type="text" style="margin-top: 10px"
                placeholder="{{ __('Please Enter Your Email') }}">
        </form>
        <div class="flex-b align-c flex-c column exit-popup-input">
            <button id="exit-popup-form-submit" type="button" class="button secondary email-submit">
                {{ __('Email me discount code') }}
            </button>
            <div id="exit-popup-form-error-text" style="text-align: center; display: none; padding: 8px" class="subscribe-failed">{{ __('Please enter your custom proposal, and your valid email.') }}</div>
            <small>
                <a class="close-exit-popup">{{ __('No Thanks') }}</a>
            </small>
        </div>
        <div style="text-align: center; display: none; padding: 8px" class="exit-popup-success subscribe-successful">
           {{ __('Thank you for your proposal.') }}
        </div>
        <span class="exit-popup-close close-exit-popup">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x"
                viewBox="0 0 16 16">
                <path
                    d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z" />
            </svg>
        </span>
    </div>
    <div class="exit-popup-background close-exit-popup"></div>
</div>
<script>
    var exitIntentRouteName = '{{ $routeName }}';
</script>
<script src="{{ asset('modules/subscription/js/exit-intent.js') }}"></script>