<?php
    $configDiscount = config('subscription::sa.percent_discount', 10);
?>
<style media="screen">
    .md-newletter-wrapper {
        background-color: #fff;
        padding-top: 32px;
        padding-bottom: 32px;
    }
    .md-newletter-content {
        max-width: 1200px;
        padding-left: 32px;
        padding-right: 32px;
        margin: 0 auto;
        width: 100%;
        font-family: Arial;
    }

    .md-newletter-form {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        flex-wrap: wrap;
    }
    .md-newletter-left,
    .md-newletter-right {
        width: 100%;
        position: relative;
        margin-bottom: 10px;
    }

    .md-newletter-head {
        font-size: 27px;
        line-height: 1;
        font-weight: 600;
        margin: 0;
    }

    .md-newletter-text {
        font-size: 15px;
        color: #444;
    }

    .md-newletter-label {
        position: absolute;
        top: 10px;
        left: 10px;
        display: inline-block;
        margin: 0;
        padding: 0;
        font-weight: normal;
        user-select: none;
        color: #666;
        z-index: 0;
        transition: all 350ms ease-in-out;
        font-size: 16px;
        pointer-events: none;
    }

    .md-newletter-input {
        display: block;
        width: 100%;
        padding: 14px 100px 2px 10px;
        line-height: 1.57143;
        background-color: #fff;
        background-image: none;
        border: 1px solid #d1d1d1;
        border-radius: 3px;
        font-size: 16px;
        transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
        transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
        transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
        background-clip: padding-box;
        transition: border .2s ease-in-out,background-color .2s ease-in-out;
        outline: 0;
        transition: all 350ms ease-in-out;
    }

    .md-newletter-input:focus {
        color: #495057;
        border-color: #80bdff;
        outline: 0;
        box-shadow: 0 0 0 0.2rem rgb(0 123 255 / 25%);
    }

    .md-newletter-right.active .md-newletter-label {
        top: 3px;
        font-size: 11px;
    }

    .md-newletter-wrapper ::-webkit-input-placeholder {
        opacity: 0
    }

    .md-newletter-wrapper :-ms-input-placeholder {
        opacity: 0
    }

    .md-newletter-wrapper ::placeholder {
        opacity: 0
    }

    .md-newletter-wrapper .md-newletter-right.active ::-webkit-input-placeholder {
        opacity: 1;
    }

    .md-newletter-wrapper .md-newletter-right.active :-ms-input-placeholder {
        opacity: 1
    }

    .md-newletter-wrapper .md-newletter-right.active ::placeholder {
        opacity: 1
    }

    .md-newletter-button {
        display: inline-block;
        font-weight: 400;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        user-select: none;
        color: #fff;
        background-color: var(--primary-dk);
        border: none;
        padding: 8px 15px;
        font-size: 16px;
        line-height: 1.5;
        position: absolute;
        top: 1px;
        right: 1px;
        height: 41px;
        border-radius: 0 3px 3px 0;
        cursor: pointer;
        outline: 0;
        width: 90px;
    }

    .md-newletter-message {
        font-weight: 500;
    }
    .md-newletter-mes {
        display: none;
        font-weight: 500;
        font-size: 13px;
        padding: 5px 0;
        width: 100%;
    }

    .md-newletter-successful {
        color: #28a745
    }

    .md-newletter-failed {
        color: #ff4e00;
    }

    .md-newsletter-loading {
        width: 20px;
        height: 20px;
        margin: 0 auto;
        display: block;
        border-radius: 20px;
        border-width: 2px;
        border-style: solid;
        border-color: #fff rgba(255, 255, 255, 0.5) rgba(255, 255, 255, 0.5) #fff;
        animation: lds-dual-ring 1000ms linear infinite;
    }

    @keyframes lds-dual-ring {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }

    @media (min-width: 1024px) {
        .md-newletter-left {
            width: 60%;
        }
        .md-newletter-right {
            width: 40%;
        }
    }

    @media (max-width: 1024px) {
        .md-newletter-left,
        .md-newletter-right {
            text-align: center;
        }
    }

    @media (max-width: 760px) {
        .md-newletter-head {
            font-size: 21px;
            margin-bottom: 5px;
        }
        .md-newletter-text {
            font-size: 12px;
        }
    }
</style>
<div class="md-newletter-wrapper">
    <div class="md-newletter-content">
        <form class="md-newletter-form" action="#" method="post">
            <div class="md-newletter-left">
                <div class="md-newletter-head">
                    {{ __('Exclusive ' . $configDiscount . '% Discount')}}
                </div>
                <div class="md-newletter-text">
                    {{ __('Join our Email List and get ' . $configDiscount . '% OFF on your first order.')}}
                </div>
            </div>
            <div class="md-newletter-right">
                <label class="md-newletter-label" for="">{{ __('Please enter your email here')}}</label>
                <input type="email" class="md-newletter-input" required placeholder="john@example.com">
                <button type="submit" class="md-newletter-button">
                    <span>{{ __('Submit')}}</span>
                    <small class="md-newsletter-loading" style="display: none;"></small>
                </button>
                <div class="md-newletter-mes md-newletter-successful">
                    {{ __('Thanks for signing up!')}}
                </div>
            </div>
        </form>
    </div>
</div>
<script type="text/javascript">
    a = document.querySelector('.md-newletter-right')
    b = document.querySelector('body');
    a.addEventListener('click', function(event) {
        this.classList.add('active');
        event.stopPropagation();
    })
    b.addEventListener('click', function () {
        if (!$('.md-newletter-input').val()) {
            document.querySelector('.md-newletter-right').classList.remove('active')
        }

    })
    document.addEventListener("DOMContentLoaded", function(event) {
        $('.md-newletter-form').on('submit', function(e){
            e.preventDefault();
            $('.md-newletter-mes').css('visibility', 'hidden');
            var email = $('.md-newletter-input').val();
            if (email) {
                $('.md-newletter-button span').hide();
                $('.md-newletter-button small').show();
                var data = {email: email}
                $.ajax({
                    url: '/subscription',
                    type: 'post',
                    dataType: 'json',
                    data: data,
                    success: function (data) {
                        $('.md-newletter-mes').css('visibility', 'visible');
                        setTimeout(function () {
                            $('.md-newletter-mes').css('visibility', 'hidden');
                        }, 3000);
                        $('.md-newletter-button span').show();
                        $('.md-newletter-button small').hide();
                    }
                });
            }



        });
    });

</script>
