<style>
    .footer-signup {
        background-color: #FFFFFF;
    }
    .footer-subscribe {
        padding: calc(var(--large-padding) * 2)
    }

    .settings-container {
        padding: var(--large-padding)
    }

    .subscribe-message {
        font-weight: 500;
    }
    .subscribe-mes {
        display: none;
        font-weight: 500;
    }

    .subscribe-successful {
        color: var(--successful);
    }

    .subscribe-failed {
        color: var(--secondary-dk);
    }

    .form-subscribe {
        max-width: 320px;
        margin: var(--small-padding) auto;
        position: relative;
    }.subscribe-mes {
        width: 100%;
    }

    .subscribe-message img {
        width: calc(var(--large-padding) * 2);
        height: calc(var(--large-padding) * 2);
        object-fit: contain;
    }

    .subscribe-message span {
        padding-left: var(--small-padding);
        font-weight: 500;
    }

    .form-control.subscribe-text {
        border-width: 2px;
        border-color: transparent transparent var(--flash) transparent;
        padding-right: var(--large-padding);
        padding-left: 0;
    }

    .form-control.subscribe-text:focus,
    .form-control.subscribe-text:active {
        border-bottom-color: var(--primary-lt)
    }
    .subscribe-button {
        width: 30px;
        min-width: 30px;
        position: absolute;
        height: 38px;
        top: 0;
        right: 0;
        padding: 0;
        border: 0;
        background-color: transparent;
    }
</style>
<?php
    $configDiscount = getOption('subscription_percent_discount', 0);
    $textSubscribe = __('Subscribe to our newsletter!');
    if ($configDiscount > 0) {
        $textSubscribe = sprintf(__('Subscribe to get %s%% Promotion Code!'), $configDiscount);
    }
?>
<div class="footer-signup">
    <div class="footer-subscribe">
        <div class="subscribe-message flex-b align-c flex-c">
            <span>
                @php
                    $subsFormText = __('Yes! Send me exclusive offers, unique gift ideas, and personalized tips for shopping and selling on %s.');
                    $subsFormText = preg_replace('/(\d+)%/i', "$1%%", $subsFormText);
                @endphp
                {{ sprintf( $subsFormText, env('APP_NAME'))}}
            </span>
        </div>
        <div class="form-subscribe">
            <input class="form-control subscribe-text" id="subscribe-email" type="text" autocomplete="off" placeholder="{{ __('Your email address') }}">
            <button class="button subscribe-button flex-b align-c flex-c" type="button" name="submit">
                {{ __('Subscribe')}}
            </button>
            <div class="subscribe-mes subscribe-successful">
                {{ __('Thanks for signing up!') }}
            </div>
            <div class="subscribe-mes subscribe-failed">
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    let isSendPromoEmail = <?=  getOption('is_show_promo_email', false) ? 'true' : 'false'; ?>;
    document.addEventListener("DOMContentLoaded", function(event) {
        function validateEmail(email) {
            var re = /\S+@\S+\.\S+/;
            return re.test(email);
        }
        $(document).ready(function() {
            $("#subscribe-email").on('keyup', function(e) {
                if (e.keyCode !== 13) {
                    return false;
                }
                let email = $('#subscribe-email').val();
                $('.subscribe-failed').text("");
                if (!validateEmail(email)) {
                    $('.subscribe-failed').show();
                    $('.subscribe-failed').text("{{ __('Invalid email address!') }}");
                    setTimeout(() => {
                        $('.subscribe-failed').hide();  
                    }, 3000);
                    return;
                }
                if (e.key === 'Enter' || e.keyCode === 13) {
                    $.ajax({
                        type: 'post',
                        url: '/subscription',
                        data: {
                            email: email,
                        },
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        },
                        success: function(response) {
                            if (response.status == 'successful') {
                                $('.subscribe-successful').show();
                                setTimeout(() => {
                                    $('.subscribe-successful').hide();  
                                }, 3000);
                            } else {
                                $('.subscribe-failed').show();
                                $('.subscribe-failed').text(response.message);
                                setTimeout(() => {
                                    $('.subscribe-failed').hide();  
                                }, 3000);
                            }
                        }
                    });
                    return false;
                }
            });
            $('.subscribe-button').click(function(e) {
                let email = $('#subscribe-email').val();
                $('.subscribe-failed').text("");
                if (!email) {
                    $('.subscribe-failed').show();
                    $('.subscribe-failed').text("{{ __('Please enter your email!') }}");
                    setTimeout(() => {
                        $('.subscribe-failed').hide();  
                    }, 3000);
                    return
                }
                if (!validateEmail(email)) {
                    $('.subscribe-failed').show();
                    $('.subscribe-failed').text("{{ __('Invalid email address!') }}");
                    setTimeout(() => {
                        $('.subscribe-failed').hide();  
                    }, 3000);
                    return;
                }
                $.ajax({
                    type: 'post',
                    url: '/subscription',
                    data: {
                        email: email,
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    },
                    success: function(response) {
                        if (response.status == 'successful') {
                            $('.subscribe-successful').show();
                            setTimeout(() => {
                                $('.subscribe-successful').hide();  
                            }, 3000);
                        } else {
                            $('.subscribe-failed').show();
                            $('.subscribe-failed').text(response.message);
                            setTimeout(() => {
                                $('.subscribe-failed').hide();  
                            }, 3000);
                        }
                    }
                });
                if (isSendPromoEmail) {
                    sendSubscribe(email);
                }
                return false;
            });
        });

        function sendSubscribe(emailSubscribe) {
            const data = {
                "target_type": "subscribe",
                "target_id": 0,
                "event_type": "mail_subscribe",
                "data": JSON.stringify({email: emailSubscribe,'current_url': window.location.href})
            };
            // var _learnq = _learnq || [];
            $.ajax({
                type: 'POST',
                url: '/send-email-subscribe',
                data: data,
                success: function (response) {
                },
                error: function (error) {
                    console.log(error);
                }
            });
        }
    });
</script>