<style>
    .footer-signup {
        background-color: #FFFFFF;
    }
    .footer-subscribe {
        padding: calc(var(--large-padding) * 2)
    }

    .settings-container {
        padding: var(--large-padding)
    }

    .subscribe-message {
        font-weight: 500;
    }
    .subscribe-mes {
        display: none;
        font-weight: 500;
    }

    .subscribe-successful {
        color: var(--successful);
    }

    .subscribe-failed {
        color: var(--secondary-dk);
    }

    .form-subscribe {
        max-width: 320px;
        margin: var(--small-padding) auto;
        position: relative;
    }.subscribe-mes {
        width: 100%;
    }

    .subscribe-message img {
        width: calc(var(--large-padding) * 2);
        height: calc(var(--large-padding) * 2);
        object-fit: contain;
    }

    .subscribe-message span {
        padding-left: var(--small-padding);
        font-weight: 500;
    }

    .form-control.subscribe-text {
        border-width: 2px;
        border-color: transparent transparent var(--flash) transparent;
        padding-right: var(--large-padding);
        padding-left: 0;
    }

    .form-control.subscribe-text:focus,
    .form-control.subscribe-text:active {
        border-bottom-color: var(--primary-lt)
    }
    .subscribe-button {
        width: 30px;
        min-width: 30px;
        position: absolute;
        height: 38px;
        top: 0;
        right: 0;
        padding: 0;
        border: 0;
        background-color: transparent;
    }
</style>
<?php
    $configDiscount = getOption('subscription_percent_discount', 0);
    $textSubscribe = __('Subscribe to our newsletter!');
    if ($configDiscount > 0) {
        $textSubscribe = sprintf(__('Subscribe to get %s%% Promotion Code!'), $configDiscount);
    }
?>
<div class="footer-signup">
    <div class="footer-subscribe">
        <div class="subscribe-message flex-b align-c flex-c">
            <picture style="width: inherit;">
                <source media="(min-width: 320px)" srcset="{{ asset('/assets/images/subscribe-image.svg') }}" />
                <source src="/images/blank.gif" />
                <img src="/images/blank.gif" alt="<?= $textSubscribe ?>" loading="lazy" />
            </picture>
            <span><?= $textSubscribe ?></span>
        </div>
        <div class="form-subscribe">
            <input class="form-control subscribe-text" id="subscribe-email" type="text" autocomplete="off" placeholder="{{ __('Your email address') }}">
            <button class="button subscribe-button flex-b align-c flex-c" type="button" name="submit">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-cursor" viewBox="0 0 16 16">
                    <path d="M14.082 2.182a.5.5 0 0 1 .103.557L8.528 15.467a.5.5 0 0 1-.917-.007L5.57 10.694.803 8.652a.5.5 0 0 1-.006-.916l12.728-5.657a.5.5 0 0 1 .556.103zM2.25 8.184l3.897 1.67a.5.5 0 0 1 .262.263l1.67 3.897L12.743 3.52 2.25 8.184z"/>
                </svg>
            </button>
            <div class="subscribe-mes subscribe-successful">
                {{ __('Thanks for signing up!')}}
            </div>
            <div class="subscribe-mes subscribe-failed">
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    document.addEventListener("DOMContentLoaded", function(event) {
        function validateEmail(email) {
            var re = /\S+@\S+\.\S+/;
            return re.test(email);
        }
        $(document).ready(function() {
            $(".subscribe-text").on('keyup', function(e) {
                let form = $(this).parent('.form-subscribe');
                if (e.keyCode !== 13) {
                    return false;
                }
                let email = $(this).val();
                $('.subscribe-failed').text("");
                if (!validateEmail(email)) {
                    $(form).find('.subscribe-failed').show();
                    $(form).find('.subscribe-failed').text("{{ __('Invalid email address!') }}");
                    setTimeout(() => {
                        $(form).find('.subscribe-failed').hide();  
                    }, 3000);
                    return;
                }
                if (e.key === 'Enter' || e.keyCode === 13) {
                    $.ajax({
                        type: 'post',
                        url: '/subscription',
                        data: {
                            email: email,
                        },
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        },
                        success: function(response) {
                            if (response.status == 'successful') {
                                $(form).find('.subscribe-successful').show();
                                setTimeout(() => {
                                    $(form).find('.subscribe-successful').hide();  
                                }, 3000);
                            } else {
                                $(form).find('.subscribe-failed').show();
                                $(form).find('.subscribe-failed').text(response.message);
                                setTimeout(() => {
                                    $(form).find('.subscribe-failed').hide();  
                                }, 3000);
                            }
                        }
                    });
                    return false;
                }
            });
            $('.subscribe-button').click(function(e) {
                let form = $(this).parent('.form-subscribe');
                let email = $(form).find('input.subscribe-text').val();
                $(form).find('.subscribe-failed').text("");
                if (!email) {
                    $(form).find('.subscribe-failed').show();
                    $(form).find('.subscribe-failed').text("{{ __('Please enter your email!') }}");
                    setTimeout(() => {
                        $('.subscribe-failed').hide();  
                    }, 3000);
                    return
                }
                if (!validateEmail(email)) {
                    $(form).find('.subscribe-failed').show();
                    $(form).find('.subscribe-failed').text("{{ __('Invalid email address!') }}");
                    setTimeout(() => {
                        $(form).find('.subscribe-failed').hide();  
                    }, 3000);
                    return;
                }
                $.ajax({
                    type: 'post',
                    url: '/subscription',
                    data: {
                        email: email,
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    },
                    success: function(response) {
                        if (response.status == 'successful') {
                            $(form).find('.subscribe-successful').show();
                            setTimeout(() => {
                                $(form).find('.subscribe-successful').hide();  
                            }, 3000);
                        } else {
                            $(form).find('.subscribe-failed').show();
                            $(form).find('.subscribe-failed').text(response.message);
                            setTimeout(() => {
                                $(form).find('.subscribe-failed').hide();  
                            }, 3000);
                        }
                    }
                });
                return false;
            });
        });
    });
</script>