<?php

namespace Modules\SystemLog\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\SystemLog\Controllers\Controller;
use Module;

class HomeController extends Controller
{
    public function __construct()
    {        
        Module::onView("content", function() {
            return "This is content view from SystemLog Module HomeController";
        }, 5);
    }
    public function index(Request $request)
    {
        $message = config("system-log::app.message");
        return view('system-log::home.welcome', [
            'message' => $message,
        ]);
    }

    public function management () {
        return view('system-log::management');
    }
    public function managementErrorLog () {
        return view('system-log::system.error-log');
    }

    public function find (Request $request) {
        $query = DB::table('system_log');
        if ($request->input('table')) {
            $query->where('table', '=', $request->input('table'));
        }
        if ($request->input('from_date')) {
            $date = \DateTime::createFromFormat('Y-m-d', $request->input('from_date'));
            $query->where('created_at', '>=', $date->setTime(0, 0, 0));
        }
        if ($request->input('to_date')) {
            $date = \DateTime::createFromFormat('Y-m-d', $request->input('to_date'));
            $query->where('created_at', '<=', $date->setTime(23, 59, 59));
        }
        if ($request->input('type')) {
            $query->where('type', '=', $request->input('type'));
        }
        if ($request->input('target_id')) {
            $query->where('target_id', '=', $request->input('target_id'));
        }
        if ($request->input('search_data')) {
            $query->where('data', 'like', '%' . $request->input('search_data') . '%');
        }
        $data = $query->orderBy('id', 'desc')
            ->get();
        foreach ($data as $item) {
            $item->data = json_decode($item->data);
            $item->date = date('d/m/Y H:i:s', strtotime($item->created_at));
        }
        return response()->json([
            'status' => 'successful',
            'result' => $data
        ]);
    }
    public function findErrorLog (Request $request) {
        $query = DB::table('error_log');
        if ($request->input('from_date')) {
            $date = \DateTime::createFromFormat('Y-m-d', $request->input('from_date'));
            $query->where('created_at', '>=', $date->setTime(0, 0, 0));
        }
        if ($request->input('to_date')) {
            $date = \DateTime::createFromFormat('Y-m-d', $request->input('to_date'));
            $query->where('created_at', '<=', $date->setTime(23, 59, 59));
        }
        if ($request->input('search_data')) {
            $query->where('data', 'like', '%' . $request->input('search_data') . '%');
        }
        $data = $query->orderBy('id', 'desc')
            ->get();
        foreach ($data as $item) {
            $item->data = json_decode($item->data);
            $item->date = date('d/m/Y H:i:s', strtotime($item->created_at));
        }
        return response()->json([
            'status' => 'successful',
            'result' => $data
        ]);
    }
}
