<?php 

namespace Modules\SystemLog\Controllers;

use App\Modules\SystemLog\Services\LogReaderService;
use Illuminate\Http\Request;

class LogReaderController extends Controller 
{

    protected $logReaderService;

    public function __construct()
    {
        $this->logReaderService = new LogReaderService;

    }

    public function index() {
        $dailyLog = $this->logReaderService->getLogFileDates();
        return view('system-log::system.log-reader')->with(compact('dailyLog'));
    }   

    /**
     * 
     * @param Symfony\Component\HttpFoundation\Request request
     */
    public function getLog(Request $request) {
        $response = [
            'status' => 'fail'
        ];
        $filters = $request->all();
        $result = $this->logReaderService->readLog($filters);
        if ($result['status'] == 'successful') {
            $response = [
                'status' => 'successful',
                'result' => $result['result'],
                'types' => $result['types']
            ];
        }
        return response()->json($response);
    }

    /**
     * 
     */
    public function getLogDate() {
        $response = [
            'status' => 'successful'
        ];
        $dailyLog = $this->logReaderService->getLogFileDates();
        $response['result'] = $dailyLog;
        return response()->json($response);
    }
}