system.controller("LaravelLogController", LaravelLogController);

function LaravelLogController($scope, $http) {
        $scope.title = "Log Reader";
        $scope.selectedType = undefined;
        $scope.logTypes = ['ALL', 'INFO', 'EMERGENCY', 'CRITICAL', 'ALERT', 'ERROR', 'WARNING', 'NOTICE', 'DEBUG'];
        $scope.logDates = [];
        $scope.logItems = [];
        $scope.filter = {};
        var originalData = null;

        this.initialize = function() {
            $scope.logDates = JSON.parse(dailyLogs);
            $scope.filter.selectedDate = $scope.logDates[0];
            $scope.filter.selectedType = $scope.logTypes[0];
            $scope.readLog();
        }

        $scope.readLog = function() {
            var filters = {
                log_date: $scope.filter.selectedDate
            };
            if ($scope.filter.search_data) {
                filters.search = $scope.filter.search_data;
            }
            $http.get('/system-log/file/find', {
                params: filters
            })
            .then(res => {
                var data = res.data;
                if (data.status == 'successful') {
                    $scope.logItems = data.result;
                    originalData = data.result;
                }
            })
        }

        $scope.filterByType = function () {
            if ($scope.filter.selectedType !== 'ALL') {
                $scope.logItems = originalData.filter(i => i.type == $scope.filter.selectedType);
            }
        };

        $scope.clear = function () {
            $scope.filter = {};
            $scope.filter.selectedDate = $scope.logDates[0];
            $scope.filter.selectedType = $scope.logTypes[0];
            $scope.readLog();
        }

        this.initialize();

}