system.controller("SystemLogController", SystemLogController);

function SystemLogController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
    $scope.controllerName = "SystemLogController";
    $scope.filter = {
    };
    this.initialize = function() {
        toastr.options = {
            "debug": false,
            "positionClass": "toast-bottom-right",
            "onclick": null,
            "fadeIn": 300,
            "fadeOut": 1000,
            "timeOut": 5000,
            "extendedTimeOut": 1000
        };
        $scope.reset();
    }
    $scope.types = [
        {code: 'INSERT', name: 'Thêm', label: 'success'},
        {code: 'UPDATE', name: 'Sửa', label: 'warning'},
        {code: 'DELETE', name: 'Xóa', label: 'danger'},
    ];
    $scope.logs = [];
    $scope.afterSearch = false;
    $scope.reset = function () {
        $scope.filter = {
        }
    }

    $scope.find = function () {
        $scope.afterSearch = false;
        if (!$scope.filter.table) {
            toastr.error('Vui lòng nhập bảng cần tìm kiếm!');
            return;
        }
        if (!$scope.filter.from_date || !$scope.filter.to_date) {
            toastr.error('Vui lòng nhập đầy đủ ngày tạo!');
            return;
        }
        $('#search').attr('dt-text', $('#crawl-btn').text());
        $('#search').text('Đang tìm kiếm');
        $('#search').attr("disabled", true);
        var url = '/system-log/find?table=' + $scope.filter.table + '&from_date=' + $('#from-date').val() + '&to_date=' + $('#to-date').val();
        if ($scope.filter.type) {
            url += '&type=' + $scope.filter.type.code
        }
        if ($scope.filter.target_id) {
            url += '&target_id=' + $scope.filter.target_id
        }
        if ($scope.filter.search_data) {
            url += '&search_data=' + $scope.filter.search_data
        }
        $http({
            method: 'GET',
            url: url
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                $scope.logs = response.data.result;
            }

            $('#search').text('Tìm kiếm');
            $('#search').attr("disabled", false);
            $scope.afterSearch = true;
            setTimeout(function () {
                $('[data-toggle="popover"]').popover({
                    html: true,
                    trigger: "click",
                    sanitize: false
                });
            })
        });

    }

    $scope.getTypeLabel = function (type) {
        var label = '';
        var typeObj = $scope.getByCode($scope.types, type);
        if (typeObj) {
            label = typeObj.label;
        }
        return label;
    }

    $scope.getLogDetail = function (data) {
        let retVal = '<table class="table table-bordered">' +
            '<tr>' +
            '<th>Trường</th>' +
            '<th>Dữ liệu</th>' +
            '</tr>';
        if (data) {
            for (var key in data) {
                retVal += '<tr>'
                retVal += '<td>' + key + '</td>';
                retVal += '<td>' + data[key] + '</td>';
                retVal += '</tr>'
            }
        }
        retVal += '</table>';
        return retVal;
    }

    this.initialize();

}
