@extends('system.layout.main', [
'ngController' => 'ErrorLogController'
])
@section('title')
    <title>Log</title>
@endsection
@section('css')
    <link rel="stylesheet" href="/system/css/chosen.min.css">
    <style>
        .popover {
            max-width: 1000px;
        }
        .popover-content {
            overflow-y: scroll;
            max-height: 90vh;
        }
    </style>
@endsection
@section('script')
    <script src="<?= Module::asset('system-log/js/error-log-controller.js') ?>" charset="utf-8"></script>
    <script src="/system/js/scripts/chosen-add-option.js?v="></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Error log</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border">

                <div class="box-body">
                    <div class="box-bg-white">
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label for="">Tìm kiếm dữ liệu: </label>
                                <input ng-model="filter.search_data" class="form-control">
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label for="">Ngày tạo từ: </label>
                                <input id="from-date" ng-model="filter.from_date" class="form-control" type="date">
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label for="">Đến: </label>
                                <input id="to-date" ng-model="filter.to_date" class="form-control" type="date">
                            </div>
                        </div>
                       
                    </div>
                    <div class="box-bg-white" style="clear: both">
                        <div class="text-left container-fluid">
                            <button id="search" type="button" name="button" class="btn btn-primary add" ng-click="find()">
                                <i class="fa fa-search"></i> Tìm kiếm
                            </button>
                            <button type="button" name="button" class="btn btn-default add" ng-click="reset()">
                                <i class="fa fa-times"></i> Xóa form
                            </button>
                        </div>
                    </div>
                    <div class="box-bg-white" ng-if="logs.length > 0" style="clear: both">
                        <h3 style="clear: both; font-size: 21px; text-align: center;">Danh sách log:</h3>
                        <table class="table table-bordered product-success">
                            <thead>
                            <tr>
                                <td style="width: 10px;">#</td>
                                <td style="width: 15%;">Thời gian</td>
                                <td style="width: 15%;">Site</td>
                                <td style="width: 20%;">Url</td>
                                <td>Message</td>
                                <td style="width: 20%;">Dữ liệu</td>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="log in logs">
                                <td>@{{ $index + 1 }}</td>
                                <td>@{{ log.date }}</td>
                                <td>@{{ log.project }}</td>
                                <td>@{{ log.url }}</td>
                                <td>@{{ log.message }}</td>
                                <td>
                                    <button class="btn btn-default" data-toggle="popover" data-placement="left"
                                        data-html="true"
                                        title="Chi tiết log" data-content="@{{ getLogDetail(log.data) }}">Chi tiết
                                    </button>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="box-bg-white" ng-if="logs.length == 0 && afterSearch">
                        <h5><p>Không tìm được dữ liệu phù hợp...</p></h5>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
