@extends('system.layout.main', [
    'ngController' => 'LaravelLogController'
])
@section('title')
    <title>Laravel log reader</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="header">
        <div class="pull-left">
            <h3 class="">Dữ liệu log</h3>
        </div>
        <div class="clearfix">
        </div>
    </div>
    <br>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <div class="box-bg-white">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label for="">Tìm kiếm dữ liệu: </label>
                            <input ng-model="filter.search_data" ng-keydown="$event.keyCode === 13 && readLog()" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label for="">Type: </label>
                            <select class="form-control"
                                    ng-change="filterByType()"
                                    ng-model="filter.selectedType"
                                    ng-options="type for type in logTypes">
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label for="">Log date</label>
                            <select class="form-control"
                                    ng-change="readLog()"
                                    ng-model="filter.selectedDate"
                                    ng-options="date for date in logDates">
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label for="">&nbsp;</label>
                            <div class="text-left">
                                <button id="search" type="button" name="button" class="btn btn-primary add" ng-click="readLog()">
                                    <i class="fa fa-search"></i> Tìm kiếm
                                </button>
                                &nbsp;
                                <button type="button" name="button" ng-click="clear()" class="btn btn-default add">
                                    <i class="fa fa-times"></i> Xóa form
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-bg-white" ng-if="logItems.length > 0">
                    <table class="table table-bordered product-success">
                        <thead>
                        <tr>
                            <td style="width: 30px;">#</td>
                            <td style="width: 20%;">Thời gian</td>
                            <td>ENV</td>
                            <td style="width: 15%;">Type</td>
                            <td style="width: 10%;">Dữ liệu</td>
                        </tr>
                        </thead>
                        <tbody>
                        <tr ng-repeat="log in logItems">
                            <td>@{{ $index + 1 }}</td>
                            <td>@{{ log.timestamp }}</td>
                            <td>@{{ log.env }}</td>
                            <td><span class="badge @{{ log.type.toLowerCase() }}">@{{ log.type }}</span></td>
                            <td style="text-align: left">@{{ log.message }}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="box-bg-white" ng-if="logs.length == 0 && afterSearch">
                    <h5><p>Không tìm được dữ liệu phù hợp...</p></h5>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    var dailyLogs = '{!! json_encode($dailyLog) !!}';
</script>
<script src="/modules/system-log/js/laravel-log-controller.js?v={{ time() }}"></script>
@endsection
<style>
    body {
        margin: 0;
        padding: 0;
        background: #f4f4f4;
        font-family: sans-serif;
    }

    .btn {
        text-decoration: none;
        background: antiquewhite;
        padding: 5px 12px;
        border-radius: 25px;
    }

    header {
        min-height: 30px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px;
        background: #3F51B5;
        position: fixed;
        left: 0;
        right: 0;
        top: 0;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);
    }
    header .btn_clear_all {
        background: #de4f4f;
        color: #fff;
    }
    header .name {
        font-size: 25px;
        font-weight: 500;
        color: white;
    }

    .content {
        margin-top: 65px;
        padding: 15px;
        background: #fff;
        min-height: 100px;
    }

    .content .date_selector {
        min-height: 26px;
        min-width: 130px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }

    .top_content {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .top_content .top_content_left {
        display: flex;
    }

    .top_content .top_content_left .log_filter {
        display: flex;
        align-items: center;
        margin-left: 15px;
    }

    .top_content .top_content_left .log_filter .log_type_item {
        margin-right: 4px;
        background: #eae9e9;
        max-height: 20px;
        font-size: 11px;
        box-sizing: border-box;
        padding: 4px 6px;
        cursor: pointer;
    }

    .top_content .top_content_left .log_filter .log_type_item.active {
        background: #2f2e2f;
        color: white;
    }

    .top_content .top_content_left .log_filter .log_type_item.clear {
        background: #607D8B;
        color: white;
    }

    table {
        border: 1px solid #ccc;
        border-collapse: collapse;
        margin: 0;
        padding: 0;
        width: 100%;
    }

    table tr {
        border: 1px solid #e8e8e8;
        padding: 5px;
    }
    table tr:hover {
        background: #f4f4f4;
    }
    thead tr td {
        background: #717171;
        color: #fff;
    }

    table th,
    table td {
        padding: 5px;
        font-size: 14px;
        color: #666;
    }

    table th {
        font-size: 14px;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    @media screen and (max-width: 700px) {
        .top_content {
            flex-direction: column;
        }

        .top_content .top_content_left {
            flex-direction: column;
        }

        .top_content .log_filter {
            flex-wrap: wrap;
        }

        .top_content .log_filter .log_type_item {
            margin-bottom: 3px;
        }
    }

    @media screen and (max-width: 600px) {
        header {
            flex-direction: column;
        }

        header .name {
            margin-bottom: 20px;
        }

        .content {
            margin-top: 90px;
        }

        .btn {
            font-size: 13px;
        }

        .dt_box,
        .selected_date {
            text-align: center;
        }

        .responsive_table {
            max-width: 100%;
            overflow-x: auto;
        }

        table {
            border: 0;
        }

        table thead {
            display: none;
        }

        table tr {
            border-bottom: 2px solid #ddd;
            display: block;
            margin-bottom: 10px;
        }

        table td {
            border-bottom: 1px dotted #ccc;
            display: block;
            font-size: 15px;
        }

        table td:last-child {
            border-bottom: 0;
        }

        table td:before {
            content: attr(data-label);
            float: left;
            font-weight: bold;
            text-transform: uppercase;
        }
    }

    .badge {
        padding: 2px 8px;
        -webkit-border-radius: 25px;
        -moz-border-radius: 25px;
        border-radius: 25px;
        font-size: 11px;
    }

    .badge.info {
        background: #6bb5b5;
        color: #fff;
    }

    .badge.warning {
        background: #f7be57;
    }

    .badge.critical {
        background: #de4f4f;
        color: #fff;
    }

    .badge.emergency {
        background: #ff6060;
        color: white;
    }

    .badge.notice {
        background: bisque;
    }

    .badge.debug {
        background: #8e8c8c;
        color: white;
    }

    .badge.alert {
        background: #4ba4ea;
        color: white;
    }

    .badge.error {
        background: #c36a6a;
        color: white;
    }
    .text-left {
        display: flex;
    }
</style>