<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
$systemAuth = config('app.system_auth_middleware');
Route::group(['prefix' => 'system-log', 'middleware' => 'example'], function () use ($systemAuth) {
    Route::get('/management', [
        'as' => 'system-log::management',
        'uses' => 'HomeController@management'
    ])->middleware($systemAuth);
    Route::get('/find', [
        'as' => 'system-log::find',
        'uses' => 'HomeController@find',
    ]);

    Route::group(['prefix' => 'file'], function() {
        Route::get('/', 'LogReaderController@index')->name('system-log::log::index');
        Route::get('/find', 'LogReaderController@getLog');
        Route::get('/log-date', 'LogReaderController@getLogDate')->name('system-log::log::dates');
    });
});

Route::group(['prefix' => 'error-log', 'middleware' => 'example'], function () use ($systemAuth) {
    Route::get('/management', [
        'as' => 'error-log::management',
        'uses' => 'HomeController@managementErrorLog'
    ])->middleware($systemAuth);
    Route::get('/find', [
        'as' => 'error-log::find',
        'uses' => 'HomeController@findErrorLog',
    ]);
});
