<?php 
namespace App\Modules\SystemLog\Services;

use DateTime;

class LogReaderService {

    /**
     * 
     * @param array config
     */
    public function __construct() {
    }


    public function getLogFileDates()
    {
        $dates = [];
        $files = glob(storage_path('logs/laravel-*.log'));
        $files = array_reverse($files);
        foreach ($files as $path) {
            $fileName = basename($path);
            preg_match('/(?<=laravel-)(.*)(?=.log)/', $fileName, $dtMatch);
            $date = $dtMatch[0];
            array_push($dates, $date);
        }

        return $dates;
    }

    /**
     * 
     * @param array filters
     */
    public function readLog($filters) {
        $retval = [
            'status' => 'fail'
        ];
        $logDate = isset($filters['log_date']) ? $filters['log_date'] : NULL;
        $isGroup = isset($filters['search']) ? false : true;
        if (empty($logDate)) {
            $today = new DateTime();
            $logDate = $today->format('Y-m-d');
        }
        $fileName = 'logs/laravel-' . $logDate . '.log';
        $logFile = storage_path($fileName);
        if (file_exists($logFile)) {
            $strPattern = "^\[(?<date>.*)\]\s(?<env>\w+)\.(?<type>\w+):";
            if (isset($filters['search']) && $filters['search'] !== '')  {
                $searchStr = preg_quote($filters['search']);
                $strPattern .= "\s((.*?)$searchStr(.*?).*)";
            } else {
                $strPattern .= "(?<message>.*)";
            }
            $pattern = "/$strPattern/m";
            // dd($pattern);
            $contents = file_get_contents($logFile);
            preg_match_all($pattern, $contents, $matches, PREG_SET_ORDER, 0);
            $logs = [];
            $types = [];
            $countByMessages = [];
            foreach ($matches as $match) {
                if (!isset($types[$match['type']])) {
                    $types[$match['type']] =1;
                } else {
                    $types[$match['type']] +=1;
                }
                if ($isGroup) {
                    if (!isset($countByMessages[trim($match['message'])])) {
                        $countByMessages[trim($match['message'])] =1;
                    } else {
                        $countByMessages[trim($match['message'])] +=1;
                    }
                    $logs[trim($match['message'])] = [
                        'timestamp' => $match['date'],
                        'env' => $match['env'],
                        'type' => $match['type'],
                        'message' => trim($match['message'])
                    ];
                } else {
                    $logs[] = [
                        'timestamp' => $match['date'],
                        'env' => $match['env'],
                        'type' => $match['type'],
                        'message' => isset($match['message']) ? trim($match['message']) : trim($match[4])
                    ];
                }
            }
            if ($isGroup) {
                foreach ($countByMessages as $index => $item) {
                    if (isset($logs[$index])) {
                        $logs[$index]['message'] = $logs[$index]['message'] . ' (' . $item . ')';
                    }
                }
            }
            preg_match('/(?<=laravel-)(.*)(?=.log)/', $fileName, $dtMatch);
            $date = $dtMatch[0];
            $retval = [
                'status' => 'successful',
                'result' => array_values($logs),
                // 'currentFile' => $fileName,
                'types' => $types
            ];
        } else {
            $retval['message'] = 'File does not exists';
        }
        return $retval;
    }

    protected function readFile($file) {
        $filesize = $this->file_get_size($file);
        
        $fp = @fopen($file, "r");
        $chunk_size = (1<<24); // 16MB arbitrary
        $position = 0;

        // if handle $fp to file was created, go ahead
        if ($fp) {
        while(!feof($fp)){
            // move pointer to $position in file
            fseek($fp, $position);

            // take a slice of $chunk_size bytes
            $chunk = fread($fp,$chunk_size);

            // searching the end of last full text line (or get remaining chunk)
            if ( !($last_lf_pos = strrpos($chunk, "\n")) ) $last_lf_pos = mb_strlen($chunk);

            // $buffer will contain full lines of text
            // starting from $position to $last_lf_pos
            $buffer = mb_substr($chunk,0,$last_lf_pos);
            
            ////////////////////////////////////////////////////
            //// ... DO SOMETHING WITH THIS BUFFER HERE ... ////
            ////////////////////////////////////////////////////

            // Move $position
            $position += $last_lf_pos;

            // if remaining is less than $chunk_size, make $chunk_size equal remaining
            if(($position+$chunk_size) > $filesize) $chunk_size = $filesize-$position;
            $buffer = NULL;
        }
        fclose($fp);
        }
    }

    protected function file_get_size($file) {
        //open file
        $fh = fopen($file, "r"); 
        //declare some variables
        $size = "0";
        $char = "";
        //set file pointer to 0; I'm a little bit paranoid, you can remove this
        fseek($fh, 0, SEEK_SET);
        //set multiplicator to zero
        $count = 0;
        while (true) {
            //jump 1 MB forward in file
            fseek($fh, 1048576, SEEK_CUR);
            //check if we actually left the file
            if (($char = fgetc($fh)) !== false) {
                //if not, go on
                $count ++;
            } else {
                //else jump back where we were before leaving and exit loop
                fseek($fh, -1048576, SEEK_CUR);
                break;
            }
        }
        //we could make $count jumps, so the file is at least $count * 1.000001 MB large
        //1048577 because we jump 1 MB and fgetc goes 1 B forward too
        $size = bcmul("1048577", $count);
        //now count the last few bytes; they're always less than 1048576 so it's quite fast
        $fine = 0;
        while(false !== ($char = fgetc($fh))) {
            $fine ++;
        }
        //and add them
        $size = bcadd($size, $fine);
        fclose($fh);
        return $size;
    }

}