"use strict";

module.exports = class Queue {
    constructor(concurrency = 1, name = 'default') {
        this.concurrency = concurrency;
        this.running = 0;
        this.name = name;
        this.queue = [];
    }

    pushTask(task) {
        this.queue.push(task);
        this.next();
    }

    priority(task) {
        this.queue.unshift(task);
        this.next();
    }

    size() {
        return this.queue.length;
    }
    getRunning() {
        return this.running;
    }

    clear() {
        this.queue = [];
    }

    next() {
        const self = this;
        while (this.running < this.concurrency && this.queue.length) {
            const task = this.queue.shift();
            self.running++;
            task().then((callback) => {
                self.running--;
                console.log(this.name, 'running: ', this.running, 'length: ', this.queue.length);
                this.next();
                if (typeof callback == 'function') {
                    callback();
                }

            }).catch(function(e) {
                self.running--;
                console.log('error', self.name);
            });
        }
    }
};
