<?php

namespace Modules\Ticket\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Modules\Ticket\Models\TicketFilterSpam;
use Modules\Ticket\Models\Ticket;
use Modules\Ticket\Models\TicketNOrder;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    protected function triggerAsyncRequest($url, $method = "GET", $params = [], $headers = ['Content-Type: application/json']) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT_MS, 600);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        if (curl_errno($channel)) {
            $error = curl_error($channel);
            \Log::info('Ticket Error: ' . $error);
        }
        curl_close($channel);
        return json_decode($data, true);
    }

    protected function getFilterTicketSpam() {
        $items = TicketFilterSpam::all();
        $emails = [];
        $includes = [];
        $excludes = [];
        foreach ($items as $item) {
            if ($item->type == 'email') {
                $emails[] = $item->value;
            }
            if ($item->type == 'include') {
                $includes[] = $item->value;
            }
            if ($item->type == 'exclude') {
                $excludes[] = $item->value;
            }
        }

        return [
            'emails' => $emails,
            'includes' => $includes,
            'excludes' => $excludes
        ];
    }

    protected function checkDuplicateOrder($ticket, $orderId) {
        $retVal = [];
        $items = Ticket::with(['ticketOrders'])
                        ->where('email', $ticket->email)
                        ->get()
                        ->toArray();
        foreach ($items as $item) {
            if (!empty($item['ticket_orders'])) {
                foreach ($item['ticket_orders'] as $ticketOrder) {
                    if ($ticketOrder['order_id'] == $orderId) {
                        $retVal[] = $item['id'];
                        break;
                    }
                }
            }
        }
        if (!empty($retVal)) {
            foreach ($retVal as $id) {
                $newRetVal = array_merge($retVal, [$ticket->id]);
                if (($key = array_search($id, $newRetVal)) !== false) {
                    unset($newRetVal[$key]);
                }
                TicketNOrder::where('ticket_id', '=', $id)
                            ->where('order_id', '=', $orderId)
                            ->update(['ticket_related' => implode(',', $newRetVal)]);
            }
        }
        return $retVal;
    }
}
