<?php

namespace Modules\Ticket\Controllers;

use Module;
use Google\Client;
use Google\Service\Gmail;
use Google\Service\Oauth2;
use Illuminate\Http\Request;
use Modules\Ticket\Models\User;
use Modules\Ticket\Models\Ticket;
use Modules\Ticket\Models\Customer;
use Modules\Ticket\Models\TicketItem;
use Modules\Ticket\Models\TicketNOrder;
use Modules\Ticket\Models\TicketFilterSpam;
use Modules\Ticket\Controllers\Controller;
use Google\Service\Gmail\ModifyMessageRequest;
use Modules\Ticket\Helpers\DBConnect;
use Illuminate\Support\Str;

class GmailController extends Controller
{
    function getClient()
    {
        $client = new Client();
        $client->setApplicationName('Gmail API PHP Quickstart');
        $client->setScopes([Oauth2::USERINFO_EMAIL, Gmail::MAIL_GOOGLE_COM]);
        $client->setAuthConfig(base_path('app/Modules/Ticket/Tokens/google.json'));
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');

        return $client;
    }

    public function login() {
        $client = $this->getClient();

        $authUrl = $client->createAuthUrl();

        return redirect($authUrl);
    }

    public function getLocateByEmail($email, $default = null) {
        $locates = config('ticket::sa.emails');

        foreach ($locates as $key => $value) {
            if ($value == $email) {
                return $key;
            }
        }

        return $default;
    }

    public function appendToken(&$client, $locate) {
        $tokenPath = base_path('app/Modules/Ticket/Tokens/' . $locate . '.json');
        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            if ($accessToken) {
                $client->setAccessToken($accessToken);
            }
        }
    }

    public function index(Request $request) {
        $client = $this->getClient();
        $locate = $request->get('locate', 'us');
        $this->appendToken($client, $locate);

        $service = new Gmail($client);

        $optParams = [];
        $optParams['q'] = 'is:unread';
        // $optParams['q'] = 'from:cheryl@med-amb.org';
        $optParams['maxResults'] = 100;
        $optParams['labelIds'] = ['INBOX', 'UNREAD']; // Only show messages in Inbox
        $messages = $service->users_messages->listUsersMessages('me', $optParams);
        // $nextPageToken = $messages->nextPageToken;
        $emails = [];
        // $first = true;
        // while($nextPageToken || $first) {
            $list = $messages->getMessages();
            foreach ($list as $item) {
                $messageId = $item->getId(); 
                $check = false;
                if (!$check) {
                    $email = $this->buildEmailData($service, $messageId, $locate);
                    $emails[] = $email;
                }
            }
            // $optParams['pageToken'] = $nextPageToken; 
            // $messages = $service->users_messages->listUsersMessages('me', $optParams);
            // $nextPageToken = $messages->nextPageToken;
        //     $first = false;
        // }
        // return $emails;
       
        foreach ($emails as $email) {
            $this->storeTicket($email);
        }
        return [
            'status' => 'sucessful'
        ];
    }

    private function buildEmailData($service, $messageId, $locate) {
        $optParamsGet = [];
        $optParamsGet['format'] = 'full'; // Display message in payload
        $message = $service->users_messages->get('me', $messageId, $optParamsGet);
        $messagePayload = $message->getPayload();
        $headers = $messagePayload->getHeaders();
        $parts = $messagePayload->getParts();
        $messageBody = $this->getMessageBody($messagePayload, $parts);
        $from = '';
        $to = '';
        $subject = '';
        $replyTo = '';
        $headerMessageId = '';
        foreach ($headers as $value) {
            if ($value['name'] == 'From') {
                $from = $value['value'];
            }

            if ($value['name'] == 'Subject') {
                $subject = str_replace('Re: ', '', $value['value']);
            }
            if ($value['name'] == 'To') {
                $to = $value['value'];
            }

            if ($value['name'] == 'Message-ID') {
                $headerMessageId = $value['value'];
            }

            if ($value['name'] == 'In-Reply-To') {
                $replyTo = $value['value'];
            }
        }
        if ($from) {
            preg_match("/<(.*)>/", $from, $matches);
            if ($matches && count($matches) > 1) {
                $from = $matches[1];
            }
        }
        if ($to) {
            preg_match("/<(.*)>/", $to, $matches);
            if ($matches && count($matches) > 1) {
                $to = $matches[1];
            }
        }

        $email = [
            'id' => $messageId,
            'message_id' => $headerMessageId,
            'from' => $from,
            'to' => $to,
            'locate' => $locate,
            'subject' => $subject,
            'body' => $messageBody,
            'date' => $message->internalDate / 1000,
            'thread_id' => $message->threadId,
            'history_id' => $message->historyId,
            'attachments' => $this->getAttachments($service, $messageId, $parts),
            'reply_to' => $replyTo
        ];

        return $email;
    }

    private function getMessageBody($messagePayload, $parts) {
        $retVal = '';
        if (count($parts)) {
            $retVal = $this->getTextPart($parts, 'text/plain');
            if (!$retVal) {
                $retVal = $this->getTextPart($parts, 'text/html');
            }
            if (!empty($retVal)) {
                $retVal = implode('/n>', $retVal);
            } else {
                $retVal = false;
            }
            if (!$retVal) {
                $body = $messagePayload->getBody();
                $retVal = $this->decodeBody($body->data, 'text/html');
            }
        } else {
            $body = $messagePayload->getBody();
            $retVal = $this->decodeBody($body->data, 'text/html');
        }
        return $retVal;
    }

    private function getTextPart($parts, $type) {
        $retVal = [];
        foreach ($parts as $part) {
            if ($part->mimeType == $type && $part->body->data != '') {
                $retVal[] = $this->decodeBody($part->body->data, $type);
            }
            if (!empty($part->parts)) {
                $subRetVal = $this->getTextPart($part->parts, $type);
                $retVal = array_merge($retVal, $subRetVal);
            }
        }
        return $retVal;
    }

    private function getAttachments($service, $message_id, $parts) {
        $attachments = [];
        foreach ($parts as $part) {
            if (!empty($part->body->attachmentId)) {
                $attachment = $service->users_messages_attachments->get('me', $message_id, $part->body->attachmentId);
                // if (in_array($part->mimeType, ['image/jpeg', 'image/pjpeg', 'image/png', 'image/gif', 'image/svg+xml', 'image/webp', 'image/heic'])) {
                    $attachments[] = [
                        'filename' => $part->filename,
                        'mimeType' => $part->mimeType,
                        'data'     => strtr($attachment->data, '-_', '+/')
                    ];
                // }
            } else if (!empty($part->parts)) {
                $attachments = array_merge($attachments, $this->getAttachments($service, $message_id, $part->parts));
            }
        }
        return $attachments;
    }

    private function storeTicket($email) {
        $title = trim($email['subject']);
        $title = str_replace('Fwd:', '', $title);
        $title = str_replace('RE:', '', $title);
        $title = trim($title);
        $ticket = [
            'email' => $email['from'],
            'title' => $title
        ];
        $ticketFirst = Ticket::where('email', '=', $ticket['email'])
                                    ->where('title', '=', $ticket['title'])
                                    ->first();
        $ticketIsSpam = false;
        if (!$ticketFirst) {
            $oldTickets = Ticket::where('email', '=', $ticket['email'])
                                ->orderBy('created_at', 'DESC')
                                ->get();
            $token = md5($email['from']);
            foreach ($oldTickets as $oldTicket) {
                if (!empty($oldTicket->token_customer)) {
                    $token = $oldTicket->token_customer;
                    break;
                }
            }
            $ticketIsSpam = $this->checkIsSpam($ticket);
            $ticketFirst = Ticket::create([
                'email' => $ticket['email'],
                'title' => $ticket['title'],
                'token_customer' => $token,
                'token_ticket' => md5(time()) . Str::random(4),
                'status' => 'open',
                'type' => 'complaint',
                'is_from_email' => 1,
                'from' => 'email',
                'is_spam' => $ticketIsSpam,
                'created_at' => date('Y-m-d H:i:s', $email['date']),
                'updated_at' => date('Y-m-d H:i:s', $email['date']),
            ]);
            $this->mapOrder($ticketFirst, $email['from'], $ticketIsSpam);
        }
        
        $ticketItem = [
            'ticket_id' => $ticketFirst->id,
            'type' => 'customer',
            'email_id' => $email['id'],
            'created_at' => date('Y-m-d H:i:s', $email['date']),
            'updated_at' => date('Y-m-d H:i:s', $email['date']),
            'content' => $email['body'],
            'thread_id' => $email['thread_id'] 
        ];
        $checkExists = TicketItem::where('ticket_id', '=', $ticketFirst->id)
                                ->where('email_id', '=', $email['id'])
                                ->exists();
        if (!$checkExists) {
            $files = $this->saveAttachments($email['attachments']);
            if (!$ticketIsSpam) {
                $ticketItem['files'] = json_encode($files);
            }
            TicketItem::create($ticketItem);
            $timeNow = time();
            $date = date('Y-m-d H:i:s', strtotime('+1 day', $timeNow));
            $deadline = \DateTime::createFromFormat('Y-m-d H:i:s', $date);
            $dataUpdate = ['is_reply' => 0, 'deadline' => $deadline];
            $checkTicketClose = Ticket::where('id', '=', $ticketFirst->id)
                                        ->where('status', '=', 'close')
                                        ->exists();
            if ($checkTicketClose) {
                $dataUpdate['status'] = 'open';
            }
            Ticket::where('id', '=', $ticketFirst->id)
                    ->update($dataUpdate);
        }
    }

    private function checkIsSpam($ticket) {
        $filters = $this->getFilterTicketSpam();
        $retVal = 0;
        if (!empty($filters['emails'])) {
            if (in_array($ticket['email'], $filters['emails'])) {
                $retVal = 1;
            }
        }
        if ($retVal === 0) {
            if (!empty($filters['includes'])) {
                foreach ($filters['includes'] as $include) {
                    $pos = strpos($ticket['title'], $include);
                    if ($pos !== false) {
                        $retVal = 1;
                        break;
                    }
                }
            }
            if (!empty($filters['excludes']) && $retVal === 1) {
                foreach ($filters['excludes'] as $exclude) {
                    $pos = strpos($ticket['title'], $exclude);
                    if ($pos !== false) {
                        $retVal = 0;
                        break;
                    }
                }
            }
        }
        return $retVal;
    }

    private function mapOrder($ticket, $email, $ticketIsSpam) {
        $email = trim($email);
        $locates = getModuleLocale();
        $locateTicket = '';
        foreach ($locates as $locate) {
            try {
                if ($locate['enable'] && $locate['locale'] != 'central') {
                    $connection = DBConnect::connect($locate['locale']);
                    $customers = $connection->table('customer')->where("email", '=', $email)->pluck("id")->toArray();
                    if (!empty($customers)) {
                        $orders = $connection->table('order')
                                            ->whereIn("customer_id", $customers)
                                            ->where("payment_status", "PAID")
                                            ->orderBy("created_at", 'DESC')
                                            ->get(["id", "customer_id", "created_at", "payment_status"]);
                        if (!empty($orders)) {
                            foreach ($orders as $item) {
                                $ticketDuplicates = $this->checkDuplicateOrder($ticket, $item->id);
                                $data = [
                                    'ticket_id' => $ticket->id,
                                    'order_id' => $item->id,
                                    'type' => 'email'
                                ];
                                if (!empty($ticketDuplicates)) {
                                    $data['ticket_related'] = implode(',', $ticketDuplicates);
                                }
                                TicketNOrder::create($data);
                            }
                            $locateTicket = $locate['locale'];
                            break;
                        }
                    }
                }
            } catch (\Exception $e) {

            }
            
        }
        if ($locateTicket != '' && $ticketIsSpam == 0) {
            Ticket::where('id', '=', $ticket->id)
                        ->update(['locate' => $locateTicket]);
            $this->triggerAsyncRequest(\URL::to('/') . "/ticket/assign?ticket_id=" . $ticket->id, "GET");
        }
    }

    private function saveAttachments($attachments) {
        $retVal = [];
        foreach ($attachments as $value) {
            $path = '/files/ticket/' . date('d-m-Y', time());
            $fullPath = public_path($path);
            exec("mkdir -p '$fullPath'");
            $fileName = uniqid() . $value['filename'];
            $filePath = $fullPath . '/' . $fileName;
            $myfile = fopen($filePath, "w+");;
            fwrite($myfile, base64_decode($value['data']));
            fclose($myfile);
            $retVal[] = config('ticket::sa.file_manager_url') . $path . '/' . $fileName;
        }

        return $retVal;
    }

    private function decodeBody($rawBody, $type = 'text/plain') {
        $sanitizedData = strtr($rawBody,'-_', '+/');
        $messageBody = base64_decode($sanitizedData);
        if ($type == 'text/html') {
            return $messageBody;
        }
        $old = $messageBody;
        if ($messageBody) {
            $messageBody = strip_tags($messageBody);
            $old = $messageBody;
            $messageBody = str_replace(array("\r\n", "\r"), "\n", $messageBody);
            $messageBody = preg_replace("/<\\n/", '<', $messageBody);
            $messageBody = preg_replace("/(\n)+/", "\\n", $messageBody);
            $arrMessage = explode(':\n>', $messageBody);
            $retVal = [];
            if (count($arrMessage)) {
                foreach ($arrMessage as $item) {
                    if ($item) {
                        $lines = explode('\n', $item);
                        if (count($lines)) {
                            unset($lines[count($lines) - 1]);
                            $lines = array_values($lines);
                            $arrNewLines = [];
                            foreach ($lines as $line) {
                                $newLine = str_replace('\\n', '', $line);
                                $newLine = trim($newLine);
                                if ($newLine != '' && $newLine != '>') {
                                    $arrNewLines[] = $newLine;
                                }
                            }
                            
                            if (!empty($arrNewLines)) {
                                $retVal[] = str_replace('\n>','', implode('\\n', $arrNewLines));
                            }
                        }
                    }
                }
            }
            if (!empty($retVal)) {
                $messageBody = implode('\\n', $retVal);
            } else {
                $messageBody = false;
            }
            $messageBody = str_replace("\\n", '<br />', $messageBody);
        }
        if (!$messageBody) {
            $messageBody = $old;
        }
        return $messageBody;
    }

    private function removeDuplicateContent($emails) {
        $emails = array_reverse($emails);
        $size = count($emails);
        for ($i = 0; $i < $size - 1; $i++) {
            $j = $i + 1;
            $emails[$j]['body'] = str_replace($emails[$i]['body'], '', $emails[$j]['body']);
        }

        $emails = array_reverse($emails);

        return $emails;
    }

    public function callback(Request $request) {
        $client = $this->getClient();
        if (isset($_GET['code'])) {
            $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);

            $googleOauth = new Oauth2($client);
            $email = $googleOauth->userinfo->get()->email;
            $tokenPath = '';
            $locate = $this->getLocateByEmail($email);
            if ($locate) {
                $tokenPath = base_path('app/Modules/Ticket/Tokens/' . $this->getLocateByEmail($email) . '.json');
            }
            
            if ($tokenPath) {
                // Save the token to a file.
                if (!file_exists(dirname($tokenPath))) {
                    mkdir(dirname($tokenPath), 0700, true);
                }
                file_put_contents($tokenPath, json_encode($client->getAccessToken()));
            }
        }

        return redirect()->route('ticket::system');
    }

    public function refreshToken() {
        $url = 'https://www.googleapis.com/oauth2/v4/token';
        $params = [];
        $tokenPath = base_path('app/Modules/Ticket/Tokens/token.json');
        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            if ($accessToken) {
                $params = [
                    'client_id' => '900256861821-gh227ak4re6vajo47k399ho01ro93f9r.apps.googleusercontent.com',
                    'client_secret' => 'n0q_rhodmhw2deLn6NL7HK81',
                    'refresh_token' => $accessToken['refresh_token'],
                    'grant_type' => 'refresh_token'
                ];
            }
        }
        $headers = '';
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, 120);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($channel, CURLOPT_POST, true);
        curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        curl_close($channel);
        return json_decode($data, true);
    }
}