<?php

namespace Modules\Ticket\Controllers;

use Module;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Ticket\Models\User;
use Modules\Ticket\Models\TicketAssign;
use Illuminate\Support\Facades\Hash;
use Modules\Ticket\Controllers\Controller;
use Modules\Ticket\Models\TicketBak;
use Modules\Ticket\Models\TicketItemBak;

class TicketController extends Controller
{
    public function index(Request $request)
    {
        return view('ticket::frontend.ticket');
    }

    public function system() {
        $users = User::leftJoin('role_n_user', 'role_n_user.user_id', '=', 'users.id')
                        ->where('role_n_user.role_id', '=', 17)
                        ->where('users.status', '=', 'ACTIVE')
                        ->pluck('users.name', 'users.id');
        $locates = getModuleLocale();
        $locales = [];
        foreach ($locates as $locale) {
            if ($locale['enable']) {
                $locales[$locale['locale']] = $locale['name'];
            }
        }
        return view('ticket::system.tickets.index', ['users' => $users, 'locates' => $locales]);
    }

    public function config() {
        $items = User::leftJoin('role_n_user', 'role_n_user.user_id', '=', 'users.id')
                        ->where('role_n_user.role_id', '=', 17)
                        ->where('users.status', '=', 'ACTIVE')
                        ->get(['users.name', 'users.id']);
        $users = [];
        foreach ($items as $item) {
            $userId = (string) $item->id;
            $users[$userId] = $item->name;
        }
        $locates = getModuleLocale();
        $locales = [];
        foreach ($locates as $locale) {
            if ($locale['enable']) {
                $locales[$locale['locale']] = $locale['name'];
            }
        }
        return view('ticket::system.config-job.index', ['users' => $users, 'locates' => $locales]);
    }

    public function setting() {
        return view('ticket::system.setting.index');
    }

    public function backup(Request $request) {
        set_time_limit(3600);
        $locales = config('localization::module.locales', []);
        $apiUrls = [];
        foreach ($locales as $key => $value) {
            if ($key !== 'central') {
                $apiUrls[] = [
                    'locale' => $key,
                    'url' => "https://$key.api.printerval.com/ticket?page_size=1000"
                ];
            }
        }

        foreach ($apiUrls as $apiUrl) {
            DB::beginTransaction();
            try {
                $result = $this->triggerAsyncRequest($apiUrl['url']);
                if ($result && $result['status'] == 'successful') {
                    $tickets = $result['result'];
                    foreach ($tickets as $ticket) {
                        $newTicket = TicketBak::create([
                            'email' => $ticket['email'],
                            'title' => $ticket['title'],
                            'token_customer' => isset($ticket['token']) ? $ticket['token'] : Hash::make(str_random(20)),
                            'token_ticket' => Hash::make(str_random(20)),
                            'status' => $ticket['status'],
                            'locate' => $apiUrl['locale'],
                            'is_reply' => $ticket['answer'] ? 1 : 0,
                            'type' => 'complaint',
                            'created_at' => $ticket['created_at'],
                            'updated_at' => $ticket['updated_at']
                        ]);
                        $items = [
                            [
                                'ticket_id' => $newTicket->id,
                                'type' => 'customer',
                                'user_id' => null,
                                'content' => $ticket['content'],
                                'files' => $ticket['files'],
                                'created_at' => $ticket['created_at'],
                                'updated_at' => $ticket['created_at']
                            ]
                        ];
                        if ($ticket['answer']) {
                            array_unshift($items, [
                                'ticket_id' => $newTicket->id,
                                'type' => 'staff',
                                'user_id' => 1,
                                'content' => $ticket['answer'],
                                'files' => $ticket['answer_files'],
                                'created_at' => $ticket['answered_at'],
                                'updated_at' => $ticket['updated_at']
                            ]);
                        }
                        if (!empty($items)) {
                            foreach ($items as $item) {
                                TicketItemBak::create($item);
                            }
                        }
                    }
                }
                DB::commit();
            } catch (\Exception $ex) {
                DB::rollback();

                return $ex->getMessage() . ' File: ' . $ex->getFile() . ' Line: ' . $ex->getLine();
            }

        }

        return 'ok';
    }

    protected function triggerAsyncRequest($url, $method = "GET", $params = [], $headers = ['Content-Type: application/json']) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, 120);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        curl_close($channel);
        return json_decode($data, true);
    }
}
