<?php

namespace Modules\Ticket\Helpers;

use Config;
use DB;

class DBConnect
{
    public static function connect($market = 'central'){
        $fileEnv = '.'. $market . '.env';
        if ($market == 'us') {
            $fileEnv = '.env';
        }
        $directory = base_path() . '/'. $fileEnv;
        if (file_exists($directory)) {
            $env = self::readConfigEnv($directory);
            if ($env['host'] == null || $env['database'] == null) {
                throw new \RuntimeException(sprintf('%s market database is not exist', $market));
            }
            $connection = config('database.connections.mysql');
            $connection['host'] = $env['host'];
            $connection['database'] = $env['database'];
            config(['database.connections.market_' . $market => $connection]);
            return DB::connection('market_' . $market);
        } else {
            die("Cơ sở dữ liệu dành cho thị trường " . $market . ' không tồn tại.');
        }
    }

    public static function readConfigEnv($path) {
        if (!is_readable($path)) {
            throw new \RuntimeException(sprintf('%s file is not readable', $path));
        }

        $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        $retVal = [
            'host' => null,
            'database' => null,
        ];
        foreach ($lines as $line) {
            if (strpos(trim($line), '#') === 0) {
                continue;
            }

            list($name, $value) = explode('=', $line, 2);
            $name = trim($name);
            $value = trim($value);
            if ($name == 'DB_HOST') {
                $retVal['host'] = $value;
            }
            if ($name == 'DB_DATABASE') {
                $retVal['database'] = $value;
            }
        }
        return $retVal;
    }
}


