<?php

namespace Modules\Ticket\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Ticket\Models\Traits\BaseTrait;

class TicketAssign extends Model
{
    use BaseTrait;
    protected $connection= 'market_central';
    protected $table = 'ticket_assign';
    protected $fillable = [
        'user_id', 'locate', 'number_ticket_open', 'note', 'status', 'from_hours', 'to_hours', 'days'
    ];

    static $operationFilter = [
        'eq' => [
            "user_id",
            "locate",
            "status"
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];

    public static function buildTicketQuery($filter) {
        $query = self::buildQuery($filter);
        self::decorQuery($query, $filter);
        return $query;
    }

    public static function decorQuery($query, $filter) {
        
    }
}
