<?php

namespace Modules\Ticket\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Ticket\Models\Traits\BaseTrait;

class TicketBak extends Model
{
    protected $connection= 'market_central';
    
    use BaseTrait;
    protected $table = 'ticket';
    protected $fillable = [
        'email', 'customer_name', 'title', 'type', 'order_code', 'token_customer', 
        'token_ticket', 'status', 'is_reply', 'is_refund', 'reply_email', 'user_id', 'locate', 'deadline', 'is_from_email', 'created_at', 'updated_at'
    ];
    protected $appends = ["first_question"];
    static $operationFilter = [
        'eq' => [
            "status",
            "token_customer",
            "user_id",
            "is_reply",
            "type",
            "locate"
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
            [
                'filter' => 'not_skus',
                'column' => 'code',
            ],
        ],
        //in
        'in' => [
            [
                'filter' => 'skus',
                'column' => 'code',
            ],
        ],
        'like' => []
    ];

    public static function buildTicketQuery($filter) {
        $query = self::buildQuery($filter);
        $query->with("ticketItems");
        self::decorQuery($query, $filter);
        return $query;
    }

    public static function decorQuery($query, $filter) {
        if (array_key_exists('keyword', $filter) && $filter['keyword'] != '') {
            $query->where(function ($q) use ($filter) {
                $q->orWhere('id', '=', $filter['keyword']);
                $q->orWhere('customer_name', 'LIKE', '%' . $filter['keyword'] . '%');
                $q->orWhere('email', 'LIKE', '%' . $filter['keyword'] . '%');
                $q->orWhere('order_code', 'LIKE', '%' . $filter['keyword'] . '%');
                $q->orWhere('title', 'LIKE', '%' . $filter['keyword'] . '%');
            });
        }
    }

    public function ticketItems() {
        return $this->hasMany(TicketItem::class, 'ticket_id');
    }
    public function ticketOrder() {
        return $this->hasOne(TicketNOrder::class, 'ticket_id');
    }
    public function getFirstQuestionAttribute() {
        return TicketItem::where("ticket_id", "=", $this->id)->orderBy("id", "ASC")->first();
    }
}
