system.filter('reverse', function() {
    return function(items) {
        if (typeof items != 'undefined' && items.length > 0) {
            return items.slice().reverse();
        } else {
            return items;
        }
    };
});
system.controller("TicketConfigController", TicketConfigController);
function TicketConfigController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filter = {};
    $scope.isLoading = false;

    $scope.items = [];
    $scope.users = users;
    $scope.config = {};
    $scope.statusses = {
        'active': 'Hoạt động',
        'inactive': 'Dừng hoạt động',
        'quit_job': 'Nghỉ việc'
    };
    $scope.locates = locates;
    $scope.mode = 'create';
    $scope.dayOfWeeks = {
        '1': 'Thứ 2',
        '2': 'Thứ 3',
        '3': 'Thứ 4',
        '4': 'Thứ 5',
        '5': 'Thứ 6',
        '6': 'Thứ 7',
        '0': 'Chủ nhật'
    };
    $scope.timers = {
        '0': '0',
        '1': '1',
        '2': '2',
        '3': '3',
        '4': '4',
        '5': '5',
        '6': '6',
        '7': '7',
        '8': '8',
        '9': '9',
        '10': '10',
        '11': '11',
        '12': '12',
        '13': '13',
        '14': '14',
        '15': '15',
        '16': '16',
        '17': '17',
        '18': '18',
        '19': '19',
        '20': '20',
        '21': '21',
        '22': '22',
        '23': '23'
    };

    $scope.init = function () {
        $scope.find(true);
    }

    $scope.buildFilterUrl = function (url) {
        let params = [];
        let columns = ['user_id', 'locate', 'status'];
        for (let i = 0; i < columns.length; i++) {
            if (typeof $scope.filter[columns[i]] != 'undefined' && $scope.filter[columns[i]] != '' && $scope.filter[columns[i]] != null) {
                params.push(columns[i] + '=' + $scope.filter[columns[i]]);
            }
        }
        url += '?' + params.join('&');
        return url;
    }

    $scope.clear = function () {
        $scope.filter = {}
        $scope.find(true);
    }

    $scope.find = function (refresh) {
        if (refresh && $scope.meta) {
            $scope.meta.page_id = 0;
        }
        $scope.isLoading = true;
        let url = $scope.buildFilterUrl('/ticket/config/find');
        url = $scope.buildPaginationUrl(url);
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.items = response.data.result;
                    $scope.meta = response.data.meta;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };


    $scope.save = function () {
        console.log($scope.config);
        if (typeof $scope.config.user_id == 'undefined' && $scope.config.user_id == null) {
            toastr.error('Vui lòng chọn nhân viên xử lý.');
            return false;
        }
        if (typeof $scope.config.locate == 'undefined' && $scope.config.locate == null) {
            toastr.error('Vui lòng chọn thị trường xử lý.');
            return false;
        }
        if (typeof $scope.config.from_hours == 'undefined' && $scope.config.from_hours == null) {
            toastr.error('Vui lòng nhập giờ làm việc');
            return false;
        }
        if (typeof $scope.config.to_hours == 'undefined' && $scope.config.to_hours == null) {
            toastr.error('Vui lòng nhập giờ làm việc.');
            return false;
        }
        if (typeof $scope.config.days == 'undefined' && $scope.config.days == null) {
            toastr.error('Vui lòng nhập ngày làm việc.');
            return false;
        }
        let data = {
            user_id: $scope.config.user_id,
            locate: $scope.config.locate,
            status: $scope.config.status,
            note: $scope.config.note,
            from_hours: $scope.config.from_hours,
            to_hours: $scope.config.to_hours,
            days: $scope.config.days
        };
       if (typeof $scope.config.id != 'undefined' && $scope.config.id != null) {
            data.id = $scope.config.id;
            $http.patch('/ticket/config/update', data)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        $scope.find();
                        $('#modalForm').modal('toggle');
                        toastr.success('Bạn đã lưu cấu hình thành công');
                    } else {
                        toastr.error(response.data.message);
                    }
                }, function (error) {
                    toastr.error('Đã có lỗi xảy ra');
                })
       } else {
            $http.post('/ticket/config', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $('#modalForm').modal('toggle');
                    toastr.success('Bạn đã tạo cấu hình thành công');
                } else {
                    toastr.error(response.data.message);
                }
            }, function (error) {
                toastr.error('Đã có lỗi xảy ra');
            })
       }

    }

    $scope.openModal = function (item, mode) {
        $scope.mode = mode;
        if (item != null) {
            var config = angular.copy(item);
            $scope.config = config;
        } else {
            $scope.config = {
                status: 'active',
                from_hours: '8',
                to_hours: '17',
            };
        }
        
        $('#modalForm').modal('toggle');
    }

    

    $scope.init();
}