
system.filter('reverse', function() {
    return function(items) {
        if (typeof items != 'undefined' && items.length > 0) {
            return items.slice().reverse();
        } else {
            return items;
        }
    };
  });

system.controller("TicketController", TicketController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});
moment.locale('vi');
system.directive('ckEditorTicket', function () {
    return {
        require: '?ngModel',
        link: function (scope, elm, attr, ngModel) {
            var ck = CKEDITOR.replace(elm[0], {
                language: 'vi',
                removePlugins : 'resize',
                filebrowserBrowseUrl: baseFileManagerUrl + '/laravel-filemanager',
                // filebrowserBrowseUrl: baseFileManagerUrl + '/laravel-filemanager?type=Files',
                filebrowserUploadUrl: baseFileManagerUrl + '/upload?' + (attr['uploadType'] ? 'type=' + attr['uploadType'] : ''),
                height: attr['height'] ? attr['height'] : 500,
                allowedContent: true,
            });
            ck.on( 'fileUploadResponse', function( evt ) {
                evt.stop();
                var data = evt.data,
                    xhr = data.fileLoader.xhr,
                    response = xhr.responseText;
                    if (response) {
                        response = JSON.parse(response);
                        if (response.upload && response.upload[0]) {
                            var cdn = baseCdnUrl + "/700x0/filters:format(webp)/";
                            var url = response.upload[0].replace('https://', '');
                            url = url.replace('http://', '');
                            data.url = cdn + url;
                        }
                    }
            } );
            if (!ngModel) return;
            ck.on('instanceReady', function () {
                ck.setData(ngModel.$viewValue);
            });
            function updateModel() {
                ngModel.$setViewValue(ck.getData());
            }
            ck.on('change', updateModel);
            ck.on('key', updateModel);
            ck.on('dataReady', updateModel);

            ngModel.$render = function (value) {
                ck.setData(ngModel.$viewValue);
            };
        }
    };
});

function TicketController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filter = {
        // 'user_id': userId
        'order': 'deadline-asc',
        'status': 'open',
        'is_spam': 0
    }
    $scope.isLoading = false;
    $scope.orderStatus = {
        'PROCESSING': 'Chờ x.nhận',
        'PENDING': 'Đã xác nhận(y.cầu x.hàng)',
        'ISSUED': 'Đã xác nhận(đang x.hàng)',
        'READY_TO_SHIP': 'Đã xác nhận(đã x.hàng)',
        'CANCELED': 'Huỷ đ.hàng',
        'DELIVERING': 'Đang vận chuyển',
        'FINISHED': 'Thành công',
        'REQUEST_RETURN': 'Y. cầu trả lại',
        'RETURNED': 'Trả lại',
    };
    $scope.paymentStatus = {
        'PENDING': 'Chưa thanh toán',
        'PAID': 'Đã thanh toán',
        'PROCESSING': 'Đang xử lý',
        'REFUND': 'Hoàn tiền'
    };
    $scope.tickets = [];
    $scope.ticket = null;
    $scope.tokens = {};
    $scope.orders = [];
    $scope.countSelected = 0;
    $scope.checkedAll = 0;

    $scope.statuses = {
        'open': 'Mở', 
        'waiting_third_party': 'Đợi phản hồi từ bên thứ 3',
        'waiting_customer': 'Đợi phản hồi từ khách hàng',
        'close': 'Đóng'
    };

    $scope.froms = {
        'customer': 'Ticket khách tạo trên website',
        'email': 'Ticket khách gửi tới email',
        'fulfillment': 'Ticket tạo từ yêu cầu của fulfillment',
    };
    $scope.reply = {
        0: 'Chưa xử lý', 
        1: 'Đã trả lời'
    };
    $scope.types = {
        'order': 'Order',
        'cancel_order': 'Cancel/Refund Order',
        'change_order': 'Change Order Info',
        'tracking_code': 'Track Order',
        'claim_paypal': 'Claim Paypal',
        'unhappy_customer': 'Unhappy Customer',
        'complaint': 'Other'
    }; 
    $scope.sendTypes = {
        'order': 'Mã đơn hàng',
        'email': 'Email khách hàng'
    }
    $scope.send = {type: 'order'};
    $scope.users = ticketUsers;

    $scope.strLimit = 100;
    $scope.isShowOldFilter = false;

    $scope.locates = locates;
    $scope.orders = {
        'deadline-asc': 'Ngày hết hạn',
        'reply_at-desc': 'Trả lời gần nhất',
        'created_at-desc': 'Tạo mới nhất',
        'updated_at-desc': 'Cập nhật mới nhất'
    }
    $scope.multiple = {

    }
    $scope.isGetOrder = false;

    $scope.modeShowFilter = 'narrow';
    $scope.isSaving = false;
    $scope.isOpenNote = false;
    $scope.isOpenOrderNote = false;
    $scope.isOpenOrderDeliveryNote = false;
    $scope.ticketsHandleByCurrentUser = 0;
    $scope.userId = userId;
    $scope.init = function () {
        if (id != null && id != '') {
            openTicketById(id);
        }
        $scope.find(true);
        $scope.getTicketsHandleByCurrentUser();
    }

    $scope.buildFilterUrl = function (url) {
        let params = ['ticket_items=1'];
        let columns = [
            "keyword",
            "status",
            "is_reply",
            "user_id",
            "type",
            "locate",
            "order",
            "is_spam",
            'is_all_open',
            'from'
        ];
        for (let i = 0; i < columns.length; i++) {
            if (typeof $scope.filter[columns[i]] != 'undefined' && $scope.filter[columns[i]] != '' && $scope.filter[columns[i]] != null) {
                params.push(columns[i] + '=' + $scope.filter[columns[i]]);
            }
        }
        url += '?' + params.join('&');
        return url;
    }

    $scope.clear = function () {
        $scope.filter = {
            'order': 'deadline-asc',
            'status': 'open',
            'is_spam': 0
        };
        $scope.find(true);
        $scope.getTicketsHandleByCurrentUser();
    }

    $scope.find = function (refresh) {
        if (refresh && $scope.meta) {
            $scope.meta.page_id = 0;
        }
        
        $scope.countSelected = 0;
        $scope.checkedAll = 0;
        $scope.isLoading = true;
        let url = $scope.buildFilterUrl('ticket/find');
        url = $scope.buildPaginationUrl(url);
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    let data = buildItems(response.data.result);
                    $scope.tickets = data;
                    $scope.meta = response.data.meta;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    function buildItems(items) {
        let data = [];
        items.forEach(function (ticket) {
            if (typeof ticket.ticket_items != 'undefined') {
                let items = [];
                ticket.ticket_items.forEach(function (item) {
                    if (item.files != null && item.files != '') {
                        let fileJsons = JSON.parse(item.files);
                        let files = [];
                        if (fileJsons.length > 0) {
                            for (let i = 0; i < fileJsons.length; i++) {
                                let file = {
                                    path: fileJsons[i]
                                };
                                files.push(file);
                            }
                        }
                        item.files = files;
                    }
                    items.push(item);
                });
                ticket.ticket_items = items;
            }
            if (typeof ticket.ticket_order != 'undefined' && ticket.ticket_order && ticket.ticket_order.ticket_related != null) {
                ticket.ticket_order.ticket_related = ticket.ticket_order.ticket_related.split(',');
            }
            ticket.user_id = parseInt(ticket.user_id);
            ticket.deadline_show = ticket.deadline;
            ticket.is_from_email = parseInt(ticket.is_from_email);
            ticket.is_checked = 0;
            ticket.strLimit = 100;
            data.push(ticket);
        });
        return data;
    }


    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };

    $scope.updateStatus = function (ticket) {
        if($scope.mode == 'create') {
            return;
        }
        var data = {
            id: ticket.id,
            status: $scope.ticket.status,
        };
        $http.patch('ticket/update-status', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã Đóng ticket này thành công';
                if (ticket.status == 'open') {
                    message = "Bạn đã Mở ticket này thành công";
                }
                $scope.tickets.forEach(function (tk) {
                    if (tk.id == ticket.id) {
                        tk.status = $scope.ticket.status;
                    }
                });
                toastr.success(message);
            }
        });
    }

    $scope.updateNote = function (ticket) {
        if($scope.mode == 'create') {
            return;
        }
        var data = {
            id: ticket.id,
            note: $scope.ticket.note,
        };
        $http.patch('ticket/update-status', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã lưu ghi chú thành công';
                $scope.tickets.forEach(function (tk) {
                    if (tk.id == ticket.id) {
                        tk.note = $scope.ticket.note;
                    }
                });
                toastr.success(message);
            }
        });
    }

    $scope.updateMarket = function (ticket) {
        if($scope.mode == 'create') {
            return;
        }
        var data = {
            id: ticket.id,
            locate: $scope.ticket.locate,
        };
        $http.patch('ticket/update-status', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã cập nhật thị trường cho ticket này thành công';
                toastr.success(message);
                $scope.tickets.forEach(function (tk) {
                    if (tk.id == ticket.id) {
                        tk.locate = $scope.ticket.locate;
                    }
                });
            }
        });
    }

    $scope.updateUser = function (ticket) {
        if($scope.mode == 'create') {
            return;
        }
        var data = {
            id: ticket.id,
            user_id: $scope.ticket.user_id,
        };
        $http.patch('ticket/update-status', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã cập nhật nhân viên xử lý cho ticket này thành công';
                toastr.success(message);
                $scope.tickets.forEach(function (tk) {
                    if (tk.id == ticket.id) {
                        tk.user_id = $scope.ticket.user_id;
                    }
                });
            }
        });
    }

    $scope.updateType = function (ticket) {
        if($scope.mode == 'create') {
            return;
        }
        if (typeof $scope.ticket.type == 'undefined' || $scope.ticket.type == '' || $scope.ticket.type == null) {
            var message = 'Vui lòng chọn một loại Ticket để thực hiện cập nhật này';
            toastr.error(message);
            return false;
        }

        var data = {
            id: ticket.id,
            type: $scope.ticket.type,
        };
        $http.patch('ticket/update-status', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã cập nhật loại ticket thành công';
                toastr.success(message);
                $scope.tickets.forEach(function (tk) {
                    if (tk.id == ticket.id) {
                        tk.type = $scope.ticket.type;
                    }
                });
            }
        });
    }

    $scope.updateDeadline = function (ticket) {
        if($scope.mode == 'create') {
            return;
        }
        var data = {
            id: ticket.id,
            deadline: $scope.ticket.deadline
        };
        $http.patch('ticket/update-status', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã cập nhật ngày hết hạn thành công';
                toastr.success(message);
                $scope.tickets.forEach(function (tk) {
                    if (tk.id == ticket.id) {
                        tk.deadline_show = $scope.summarizeDateTime($scope.ticket.deadline, true);
                        tk.deadline = moment($scope.ticket.deadline).format('DD/MM/YYYY');
                    }
                });
            }
        });
    }

    $scope.mapOrder = function (ticket) {
        $scope.isGetOrder = true;
        if (typeof $scope.ticket.order_codes == 'undefined' || $scope.ticket.order_codes == '' || $scope.ticket.order_codes == null) {
            toastr.error('Vui lòng nhập mã đơn hàng bạn muốn tìm');
            $scope.isGetOrder = false;
            return false;
        }
        var data = {
            order: $scope.ticket.order_codes
        };
        if ($scope.mode == 'update') {
            data.id = $scope.ticket.id;
        }
        if (typeof ticket.locate != 'undefined' && ticket.locate != null && ticket.locate != '') {
            data.locate = ticket.locate;
        }
        $http.post('ticket/map-order', data) .then(function (response) {
            if (response.data.status == 'successful') {
                $scope.isGetOrder = false;
                $scope.ticket.relastedOrders = response.data.result;
                $scope.ticket.ticket_n_order = response.data.ticket_n_order;
                $scope.ticket.locate = response.data.locate;
            } else {
                $scope.isGetOrder = false;
                $scope.ticket.relastedOrders = [];
                toastr.error('Không tìm được đơn nào phù hợp');
            }
        });
    }

    $scope.saveTicketOrder = function (ticket) {
        var data = {
            id: ticket.id,
            order_code: $scope.ticket.order_codes,
            ticket_n_order: $scope.ticket.ticket_n_order
        };
        $http.post('ticket/save-ticket-order', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã lưu đơn hàng thành công';
                $scope.ticket.ticket_n_order = null;
                toastr.success(message);
            } else {
                toastr.error('Lưu đơn hàng không thành công, vui lòng thử lại');
            }
        });
    }

    $scope.cancelSaveTicketOrder = function () {
        $scope.ticket.ticket_n_order = null;
        $scope.ticket.relastedOrders = [];
    }

    $scope.save = function () {
        $scope.isSaving = true;
        if ($scope.mode == 'update') {
            if ($scope.ticket.answer_text == null || $scope.ticket.answer_text == '') {
                toastr.error('Vui lòng nhập câu trả lời trước khi gửi.');
                $scope.isSaving = false;
                return false;
            }
            let data = {
                ticket_id: $scope.ticket.id,
                content: $scope.ticket.answer_text,
                files: [],
                type: 'staff',
                user_id: userId
            };
            $scope.ticket.answer_files.forEach(function (file) {
                data.files.push(file.path);
            })
            $http.post('ticket/item', data)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        response.data.result.files = $scope.ticket.answer_files;
                        $scope.ticket.ticket_items.unshift(response.data.result);
                        $scope.tickets.forEach(function (tk) {
                            if (tk.id == $scope.ticket.id) {
                                tk.ticket_items = $scope.ticket.ticket_items;
                            }
                        });
                        $scope.ticket.answer_text = null;
                        $scope.ticket.answer_files = [];
                        toastr.success('Bạn đã trả lời xong ticket');
                        $scope.ticket.is_ready = 1;
                        $('#modalForm').modal('toggle');
                    } else {
                        toastr.error('Câu trả lời gửi đi không thành công, vui lòng thử lại');
                    }
                    $scope.isSaving = false;
                }, function (error) {
                    toastr.error('Câu trả lời gửi đi không thành công, vui lòng load lại trang để thử lại');
                })
        } else {
            if ($scope.ticket.title == null || $scope.ticket.title == '') {
                toastr.error('Vui lòng nhập tiêu đề trước khi gửi.');
                $scope.isSaving = false;
                return false;
            }
            if ($scope.ticket.answer_text == null || $scope.ticket.answer_text == '') {
                toastr.error('Vui lòng nhập câu trả lời trước khi gửi.');
                $scope.isSaving = false;
                return false;
            }
            if ($scope.ticket.relastedOrders.length == 0) {
                toastr.error('Không xác định được đơn hàng và khách hàng cần gửi');
                $scope.isSaving = false;
                return false;
            }

            $http.post('ticket/create-ticket', $scope.ticket)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        $scope.isSaving = false;
                        $scope.ticket.ticket_items.unshift(response.data.result);
                        $scope.ticket.answer_text = null;
                        $scope.ticket.answer_files = [];
                        toastr.success('Tạo ticket thành công')
                        $scope.find();
                        $('#modalForm').modal('toggle');
                    } else {
                        toastr.error('Tạo ticket không thành công, vui lòng kiểm tra lại dữ liệu');
                        $scope.isSaving = false;
                    }
                });

        }
        
    }

    $scope.uploadImages = async function (files, type) {
        $scope.isSaving = true;
        if (files && files.length) {
            if (type === 'send-email') {
                var images = files.length + ($scope.send.files ? $scope.send.files.length : 0);
            } else {
                var images = files.length + ($scope.ticket.answer_files ? $scope.ticket.answer_files.length : 0);
            }
            
            if (images > 5) {
                $scope.isSaving = false;
                toastr.error('Không được upload quá 5 ảnh')
                return false;
            }
            images = null;
            try {
                images = await $scope.uploads(files, 'ticket');
            } catch (error) {
            }
            if (images) {
                $scope.$applyAsync(function () {
                    for (let i = 0; i < images.length; i++) {
                        let path = images[i].replace(siteUrl, '');
                        let image = {
                            path: path
                        }
                        if (type == 'send-email') {
                            $scope.send.files.push(image);
                        } else {
                            $scope.ticket.answer_files.push(image);
                        }
                    }
                });
                $scope.isSaving = false;
            }
        }
    }

    $scope.removeImage = function($index, type) {
        if (type == 'send-email') {
            $scope.send.files.splice($index, 1);
        } else {
            $scope.ticket.answer_files.splice($index, 1);
        }
    }

    function openTicketById (id) {
        var url = "ticket/find?id=" + id + "&ticket_items=1&page_id=0&page_size=40";
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful' && response.data.result.length > 0) {
                    let data = buildItems(response.data.result);;
                    $scope.edit('update', data[0]);
                } else {
                    toastr.error('Không xác định được ticket bạn muốn tìm');
                }
            });
    }

    $scope.edit = function (mode, item) {
        $scope.mode = mode;
        if (mode == 'update') {
            $scope.isGetOrder = true;
            $scope.ticket = angular.copy(item);
            $scope.ticket.user_id = item.user_id.toString();
            $scope.ticket.relastedOrders = [];
            $scope.ticket.deadline = moment(item.deadline).format('DD/MM/YYYY');
            $scope.ticket.answer_files = [];
            var url = '/ticket/get-order?id=' + item.id;
            $http.get(url)
                .then(function (response) {
                if (response.data.status == 'successful' && response.data.id == $scope.ticket.id) {
                    var relastedOrders = [];
                    response.data.result.forEach(function(item){
                        item.is_refund = parseInt(item.is_refund);
                        relastedOrders.push(item);
                    });
                    $scope.ticket.relastedOrders = relastedOrders;
                } 
                $scope.isGetOrder = false;
            });
        } else {
            $scope.ticket = {
                type: 'order',
                status: 'open',
                user_id: userId,
                relastedOrders: [],
                ticket_items: [],
                note: ''
            };
        }
        
        $('#modalForm').modal('toggle');
    }


    $scope.openModalSendEmail = function () {
        $scope.send = {
            type: 'order',
            files: []
        }
        $('#modalSendEmail').modal('toggle');
    }

    $scope.checkAll = function() {
        if ($scope.checkedAll) {
            $scope.tickets.forEach(function (item) {
                item.is_checked = 1;
            });
            $scope.countSelected = $scope.tickets.length;
        } else {
            $scope.tickets.forEach(function (item) {
                item.is_checked = 0;
            });
            $scope.countSelected = 0;
        }
    }

    $scope.checkedItem = function() {
        var countSelected = 0;
        $scope.tickets.forEach(function (item) {
            if (item.is_checked) {
                countSelected += 1;
            }
        });
        $scope.countSelected = countSelected;
    }

    $scope.updateMultiItem = function() {
        $('#modalAction').modal('toggle');
    }

    $scope.showMore = function(item, content) {
        item.strLimit = content.length;
    };

    $scope.showLess = function(item) {
        item.strLimit = 100;
    };

    $scope.saveMultiItem = function() {
        $scope.isSaving = true;
        var columns = ['user_id', 'status', 'deadline'];
        let checkValid = false;
        for (let i = 0; i < columns.length; i++) {
            if (typeof $scope.multiple[columns[i]] != 'undefined' 
                && $scope.multiple[columns[i]]!= null 
                && $scope.multiple[columns[i]]!= '') {
                    checkValid = true;
                    break;
            }
        }
        if (!checkValid) {
            toastr.error('Yêu cầu bạn chọn một trường để cập nhật');
            $scope.isSaving = false;
            return false;
        }
        let ids = [];
        $scope.tickets.forEach(function(ticket) {
            if (ticket.is_checked) {
                ids.push(ticket.id);
            }
        });
        let data = {
            'ids': ids,
            'data': $scope.multiple
        };
        $http.post('ticket/update-multiple', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $('#modalAction').modal('toggle');
                    $scope.isSaving = false;
                } else {
                    toastr.error('Có lỗi xảy ra vui lòng thử lại');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.switchMode = function (mode) {
        $scope.modeShowFilter = mode;
    }

    $scope.sendEmail = function () {
        $scope.isSaving = true;
        if ($scope.send.value == '' || $scope.send.value == null) {
            var text = 'email khách hàng';
            if ($scope.send.type == 'order') {
                text = 'mã đơn hàng'
            }
            toastr.error('Vui lòng nhập ' + text);
            $scope.isSaving = false;
            return false;
        }
        if ($scope.send.title == '' || $scope.send.title == null) {
            toastr.error('Vui lòng nhập tiêu đề email');
            $scope.isSaving = false;
            return false;
        }
        if ($scope.send.content == '' || $scope.send.content == null) {
            toastr.error('Vui lòng nhập nội dung email');
            $scope.isSaving = false;
            return false;
        }
        var files = [];
        $scope.send.files.forEach(function (file) {
            files.push(file.path);
        })
        $scope.send.data_files = files;
        $scope.send.user_id = userId;
        $http.post('ticket/send-email', $scope.send)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $('#modalSendEmail').modal('toggle');
                    $scope.isSaving = false;
                    toastr.success('Gửi email thành công')
                } else {
                    toastr.error('Email gửi không thành công, vui lòng kiểm tra lại dữ liệu');
                    $scope.isSaving = false;
                }
            });

    }

    $scope.updateOrderNote = function (order, locate, type) {
        if (typeof locate == 'undefined' || locate == null || locate == '') {
            toastr.error('Vui lòng chọn thị trường cho đơn hàng');
            return false;
        }
        var data = {
            id: order.id,
            locate: locate,
        }
        if (type == 'note') {
            data.note = order.note;
        }
        if (type == 'delivery_note') {
            data.delivery_note = order.delivery_note;
        }
        $http.post('ticket/update-order-note', data) .then(function (response) {
            if (response.data.status == 'successful') {
                var message = 'Bạn đã cập nhật ghi chú đơn hàng thành công';
                if (type == 'note') {
                    $scope.isOpenOrderNote = false;
                } else if (type == 'delivery_note') {
                    $scope.isOpenOrderDeliveryNote = false;
                }
                
                toastr.success(message);
            } else {
                toastr.error('Có lỗi xảy ra, vui lòng thử lại');
            }
        });
    }

    $scope.copyToClipboard = function (tracking) {
        var text_to_share = tracking.url;
        // create temp element
        var copyElement = document.createElement("span");
        copyElement.appendChild(document.createTextNode(text_to_share));
        copyElement.id = 'tempCopyToClipboard';
        angular.element(document.body.append(copyElement));

        // select the text
        var range = document.createRange();
        range.selectNode(copyElement);
        window.getSelection().removeAllRanges();
        window.getSelection().addRange(range);

        // copy & cleanup
        document.execCommand('copy');
        window.getSelection().removeAllRanges();
        copyElement.remove();
    }

    $scope.updateEmailSpam = function () {
        $.confirm({
            title: 'Báo cáo spam!',
            content: 'Bạn có chắc chắn Ticket này là spam',
            buttons: {
                confirm: function () {
                    updateSpam();
                },
                cancel: function () {
                    
                }
            }
        });
    }

    function updateSpam() {
        $scope.isSaving = true;
        let ids = [];
        $scope.tickets.forEach(function(ticket) {
            if (ticket.is_checked) {
                ids.push(ticket.id);
            }
        });
        let data = {
            'ids': ids
        };
        $http.post('ticket/update-spam', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.isSaving = false;
                    toastr.success('Báo cáo spam thành công');
                } else {
                    toastr.error('Có lỗi xảy ra vui lòng thử lại');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.settingFilter = function() {
        $scope.filterSpam = {
            emails: '',
            includes: '',
            excludes: ''
        }
        var emails = [];
        $scope.tickets.forEach(function(ticket) {
            if (ticket.is_checked) {
                emails.push(ticket.email);
            }
        });
        $scope.filterSpam.emails = emails.join(', ');
        $scope.filterEmails = [];
        $scope.filterIncludes = [];
        $scope.filterExcludes = [];
        var url = 'ticket/get-filter-spam';
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.filterEmails = response.data.emails;
                    $scope.filterIncludes = response.data.includes;
                    $scope.filterExcludes = response.data.excludes;
                }
            });
        $('#modalSendEmail').modal('toggle');
    }

    $scope.applyFilter = function() {
        $scope.isSaving = true;
        if ($scope.filterSpam.emails == '' && $scope.filterSpam.includes == '' && $scope.filterSpam.excludes == '') {
            $scope.isSaving = false;
            toastr.error('Vui lòng nhập điều kiện lọc');
            return;
        }
        $http.post('ticket/create-filter-spam', $scope.filterSpam)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.isSaving = false;
                    toastr.success('Tạo bộ lọc thành công.');
                    $('#modalSendEmail').modal('toggle');
                } else {
                    toastr.error('Tạo bộ lọc không thành công. Vui lòng thử lại.');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.showOldFilter = function () {
        if (!$scope.isShowOldFilter) {
            $scope.isShowOldFilter = true;
        } else {
            $scope.isShowOldFilter = false;
        }
    }

    $scope.removeSpam = function (index, item, type) {
        $.confirm({
            title: 'Xóa phẩn tử bộ lọc!',
            content: 'Bạn có chắc chắn muốn xóa phần tử này',
            buttons: {
                confirm: function () {
                    removeSpamItem(index, item, type);
                },
                cancel: function () {
                    
                }
            }
        });
    }

    function removeSpamItem(index, item, type) {
        $http.post('ticket/remove-filter-item', item)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Xóa phần tử thành công');
                    if (type == 'email') {
                        $scope.filterEmails.splice(index, 1);
                    } else if (type == 'include') {
                        $scope.filterIncludes.splice(index, 1);
                    } else if (type == 'exclude') {
                        $scope.filterExcludes.splice(index, 1);
                    }
                } else {
                    toastr.error('Xóa phần tử không thành công. Vui lòng thử lại.');
                }
            });
    }

    $scope.updateEmailNotSpam = function() {
        $.confirm({
            title: 'Hoàn tác Ticket!',
            content: 'Bạn có chắc chắn hoàn tác ticket này',
            buttons: {
                confirm: function () {
                    updateNotSpam();
                },
                cancel: function () {
                    
                }
            }
        });
    }

    function updateNotSpam() {
        $scope.isSaving = true;
        let ids = [];
        $scope.tickets.forEach(function(ticket) {
            if (ticket.is_checked) {
                ids.push(ticket.id);
            }
        });
        let data = {
            'ids': ids
        };
        $http.post('ticket/update-not-spam', data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.isSaving = false;
                    toastr.success('Hoàn tác thành công');
                } else {
                    toastr.error('Có lỗi xảy ra vui lòng thử lại');
                    $scope.isSaving = false;
                }
            });
    }

    $scope.approveRefund = function (order) {
        var title = 'Bỏ duyệt hoàn tiền';
        var content = 'Bạn có chắc chắn duyệt hoàn tiền cho đơn ' + order.code;
        if (!order.is_refund) {
            content = 'Bạn có chắc chắn bỏ duyệt hoàn tiền cho đơn ' + order.code;
        }
        $.confirm({
            title: title,
            content: content,
            buttons: {
                confirm: function () {
                    var data = {
                        ticket_id: $scope.ticket.id,
                        order_id: order.id,
                        is_refund: order.is_refund,
                        locate: $scope.ticket.locate
                    }
                    $http.post('ticket/approve-refund', data)
                        .then(function (response) {
                            if (response.data.status == 'successful') {
                                toastr.success('Duyệt hoàn tiền thành công');
                            } else {
                                toastr.error('Có lỗi xảy ra vui lòng thử lại');
                            }
                    });
                },
                cancel: function () {
                    $scope.$apply(function () {
                        if  (order.is_refund) {
                            $scope.ticket.relastedOrders.forEach(function (item) {
                                if (item.id == order.id) {
                                    item.is_refund = 0;
                                }
                            });
                        } else {
                            $scope.ticket.relastedOrders.forEach(function (item) {
                                if (item.id == order.id) {
                                    item.is_refund = 1;
                                }
                            });
                        }
                    })
                }
            }
        });
    }

    $scope.calculateTimeAgo = function (date) {
        return moment(date).fromNow()
    }

    $scope.getTicketsHandleByCurrentUser = () => {
        $scope.isShowTicketsHandleByCurrentUser = false;
        url = `ticket/find?ticket_items=1&is_all_open=1&user_id=${userId}&order=deadline-asc`;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                        $scope.ticketsHandleByCurrentUser = response.data.meta.total_count;
                }
            })
    }

    $scope.filterTicketHandleByUser = () => {
        $scope.isShowTicketsHandleByCurrentUser = true;
        $scope.filter['user_id'] = userId
        $scope.filter["is_all_open"] = 1;
        $scope.filter['status'] = null;
        $scope.find();
        $scope.ticketsHandleByCurrentUser = 0;
    };

    $scope.init();
}