<script>
    var isChangeOrder = '{{\Illuminate\Support\Facades\Input::get('change_order')}}';
    var ticket_base_api_url = '{{ config('ticket::sa.api_url') }}';
    var base_file_manager_url = '{{ config('ticket::sa.file_manager_url') }}';
    var app = angular.module('myApp', ['ngFileUpload']);
    var requestToken = "{{ app('request')->query('token') }}";
    var messages = {
        required: {
            email: "{{ __('Please enter your email!') }}",
            title: "{{ __('Please enter subject!') }}",
            content: "{{ __('Please write description!') }}",
            type: "{{ __('Please select type!') }}",
            order_code: "{{ __('Please enter order code') }}",
            customer_name: "{{ __('Please enter your name!') }}",
        },
        email: "{{ __('Your email address is not valid') }}",
        success: "{{ __('Create ticket successful!') }}",
        successQuestion: "{{ __('Create question successful!') }}",
        successUpdateStatus: "{{ __('Close ticket successfully') }}",
        error: "{{ __('There was an error. Please try again later.') }}",
        file_limit: "{{ __('The number of files must not be greater than 5.') }}"
    }
    var id = "{{isset($_GET['id']) ? $_GET['id'] : ''}}";
    toastr.options = {
        "autoDismiss": true,
        "preventDuplicates": true,
        "debug": false,
        "positionClass": "toast-bottom-right",
        "onclick": null,
        "fadeIn": 300,
        "fadeOut": 1000,
        "timeOut": 3000,
        "extendedTimeOut": 1000
    };

    app.controller('TicketController', function ($scope, $http, $rootScope, $sce, Upload) {
        $scope.openTickets = [];
        $scope.closeTickets = [];
        $scope.isCreating = false;
        $scope.isViewTicket = false;
        $scope.isCreateNewQuestion = false;
        $scope.activeSelected = "";
        $scope.ticket = {
            customer_token: '',
            title: '',
            email: '',
            content: '',
            files: [],
            type: '',
            customer_name: ''
        };
        $scope.currentTicket = {
            customer_token: '',
            title: '',
            email: '',
            content: '',
            files: [],
            type: "",
            created_at: "",
        };
        $scope.question = {
            ticket_id: '',
            content: '',
            files: [],
            type: ""
        }

        $scope.type = "all";

        $scope.customer_token = requestToken;

        $scope.isLoading = false;

        $scope.email = '';

        $scope.message = {};
        $scope.messageQuestion = {};
        $scope.meta = {
            page_id: 0,
            page_size: 20,
        };
        $scope.types = [
            {key: -1, value: "{{ __('Select') }}"},
            {key: "order", value: "{{ __('Order') }}"},
            {key: "cancel_order", value: "{{ __('Cancel / Refund Order') }}"},
            {key: "change_order", value: "{{ __('Change Order Info') }}"},
            {key: "tracking_code", value: "{{ __('Track Order') }}"},
            {key: "claim_paypal", value: "{{ __('Claim Paypal') }}"},
            {key: "unhappy_customer", value: "{{ __('Unhappy Customers') }}"},
            {key: "complaint", value: "{{ __('Other') }}"},
        ];

        $scope.id = id;

        $scope.init = function () {
            if (id != '') {
                openTicket(id);
            }
            if (!$scope.email) {
                $scope.email = $scope.getEmail();
            }
            if (!$scope.customer_token) {
                $scope.customer_token = window.localStorage.getItem('token_user_query');
            }

            if ($scope.customer_token) {
                $scope.find("all");
            }
            if (isChangeOrder == '1') {
                $scope.createChangeOrder();
            }

        }

        function openTicket(id) {
            let url = `/ticket/find?id=${id}`;
            $http.get(url).then(function (response) {
                if (response.data.status == 'successful' && response.data.result.length > 0) {
                    let data = response.data.result;
                    data.forEach(element => {
                        element.ticket_items.forEach(item => {
                            if (item.files) {
                                item.files = JSON.parse(item.files);
                            }
                        });
                    });
                    $scope.viewTicket(data[0]);
                }
            })
        }   

        $scope.find = function (type) {
            $scope.isViewTicket = false;
            $scope.type = type;
            let url = `/ticket/find?token_customer=${$scope.customer_token}`;
            if ($scope.type) {
                if ($scope.type == 'open') {
                    url += `&is_all_open=1`;
                } else if ($scope.type == 'close') {
                    url += `&status=close`;
                }
            }
            url = $scope.buildPagination(url);
            $http.get(url).then(function (response) {
                if (response.data.status == 'successful') {
                    let data = response.data.result;
                    data.forEach(element => {
                        element.ticket_items.forEach(item => {
                            if (item.files) {
                                item.files = JSON.parse(item.files);
                            }
                        });
                    });
                    $scope.meta = response.data.meta;
                    $scope.openTickets = data;
                }
            })
        }

        $scope.buildPagination = (url) => {
            url += `&page_id=${$scope.meta.page_id}&page_size=${$scope.meta.page_size}`;
            return url;
        }

        $scope.getEmail = function () {
            let email = '';
            let customerEmail = window.localStorage.getItem('customerEmail');
            email = customerEmail;
            if (!email) {
                let customerInfo = window.localStorage.getItem('customerInfo');
                if (customerInfo) {
                    customerInfo = JSON.parse(customerInfo);
                    email = customerInfo.email;
                }
            }

            return email;
        }


        $scope.validate = function () {
            let retVal = true;
            $scope.message = {};
            for (let key of Object.keys($scope.ticket)) {
                if (!$scope.ticket[key] && key != 'order_code') {
                    $scope.message[key] = messages['required'][key];
                    retVal = false;
                }
            }
            if (retVal && $scope.ticket.type == -1) {
                $scope.message["type"] = messages['required']['type'];
                retVal = false;
            }
            if (retVal && $scope.ticket.type != -1 && $scope.ticket.type != "complaint") {
                if (!$scope.ticket.order_code) {
                    $scope.message["order_code"] = messages['required']['order_code'];
                    retVal = false;
                }
            }
            if (retVal) {
                let regex = new RegExp(/(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/);
                if (!regex.test($scope.ticket.email)) {
                    $scope.message['email'] = messages['email'];;
                    retVal = false;
                }
            }

            return retVal;
        }

        $scope.save = function () {
            if ($scope.validate()) {
                $scope.isLoading = true;
                window.localStorage.setItem('customerEmail', $scope.ticket.email);
                $scope.email = $scope.ticket.email;
                let data = angular.copy($scope.ticket);
                data.files = JSON.stringify(data.files);
                $http.post('/ticket/send', data)
                    .then(function (response) {
                        $scope.find("all");
                        $scope.isCreating = false;
                        $scope.isLoading = false;
                        $('#open-tickets').addClass('active');
                        $('#toggle-open').addClass('active');
                        $('#close-tickets').removeClass('active');
                        $('#toggle-close').removeClass('active');
                        $(document).scrollTop(0);
                        toastr.success(messages['success']);
                    }, function (error) {
                        toastr.error(messages['error']);
                        $scope.isLoading = false;
                    });
            }
        }

        function addZero(num) {
            return num > 9 ? num : '0' + num;
        }

        $scope.toUsDate = function (dateTime) {
            if (dateTime) {
                var dateParts = dateTime.split("-");
                var time = dateParts[2].substr(3);
                var timeParts = time.split(':');
                var jsDate = new Date(dateParts[0], dateParts[1] - 1, dateParts[2].substr(0,2), timeParts[0], timeParts[1], timeParts[2]);
                var utcDate = new Date(jsDate.getTime() + jsDate.getTimezoneOffset() * 60000);

                return addZero(utcDate.getMonth()+1)  + "-" + addZero(utcDate.getDate()) + "-" + utcDate.getFullYear() + " " + addZero(utcDate.getHours()) + ":" + addZero(utcDate.getMinutes()) + ' (UTC)';
            }
            return;
        };

        $scope.accept = function (item) {
            if (item.status != 'close') {
                item.status = 'close';
                $http.patch('/ticket/' + item.id, item)
                    .then(function (response) {
                        toastr.success(messages['successUpdateStatus']);
                    }, function (error) {
                        toastr.error(messages['error']);
                    });
            }
        }

        $scope.createChangeOrder = function () {
            if (!$scope.customer_token) {
                $scope.customer_token = makeToken(30);
            }
            $scope.ticket = {
                token_customer: $scope.customer_token,
                token_ticket: makeToken(30),
                title: '',
                email: $scope.email,
                content: '',
                files: [],
                status: 'open',
                type: -1,
                customer_name: ''
            };
            var trackOrderCustomer = localStorage.getItem('track-order-customer');
            if (trackOrderCustomer) {
                trackOrderCustomer = JSON.parse(trackOrderCustomer);
                if (trackOrderCustomer.email) {
                    $scope.ticket.email = trackOrderCustomer.email;
                }
                if (trackOrderCustomer.full_name) {
                    $scope.ticket.customer_name = trackOrderCustomer.full_name;
                }
                if (trackOrderCustomer.order_code) {
                    $scope.ticket.order_code = trackOrderCustomer.order_code;
                }
                $scope.ticket.type = 'change_order';
                $scope.ticket.title = '{{ __('Change Order Info') }}';
                $scope.isOpenOrderCode = true;
            }
            $scope.message = {};
            $scope.isCreating = true;
            window.setTimeout(function () {
                var element = document.getElementById('description');
                element.focus();
                setCaretAtEnd(element);
            }, 50);
        }

        $scope.create = function () {
            if (!$scope.customer_token) {
                $scope.customer_token = makeToken(30);
            }
            $scope.ticket = {
                token_customer: $scope.customer_token,
                token_ticket: makeToken(30),
                title: '',
                email: $scope.email,
                content: '',
                files: [],
                status: 'open',
                type: -1,
                customer_name: ''
            };
            $scope.message = {};
            $scope.isCreating = true;
            focusSubject();
        }

        function focusSubject() {
            var element = null;
            if (!$scope.email) {
                element = document.getElementById('email');
            } else {
                element = document.getElementById('customer_name');
            }
            window.setTimeout(function () {
                element.focus();
                setCaretAtEnd(element);
            }, 50);

            element.focus();
            setCaretAtEnd(element);

        }
        function setCaretAtEnd(elem) {
            var elemLen = elem.value.length;
            // For IE Only
            if (document.selection) {
                // Set focus
                elem.focus();
                // Use IE Ranges
                var oSel = document.selection.createRange();
                // Reset position to 0 & then set at end
                oSel.moveStart('character', -elemLen);
                oSel.moveStart('character', elemLen);
                oSel.moveEnd('character', 0);
                oSel.select();
            }
            else if (elem.selectionStart || elem.selectionStart == '0') {
                // Firefox/Chrome
                elem.selectionStart = elemLen;
                elem.selectionEnd = elemLen;
                elem.focus();
            } // if
        }

        function makeToken(length) {
            var result           = '';
            var characters       = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            var charactersLength = characters.length;
            for ( var i = 0; i < length; i++ ) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            result += Date.now();
            return result;
        }

        $scope.cancel = function () {
            $scope.isCreating = false;
        }

        $scope.displayContent = function (content) {
            content = content.replace(/\n/g, "<br />");
            return $sce.trustAsHtml(content);
        }

        $scope.uploads = function (files, type = 'default') {
            $scope.isLoading = true;
            return new Promise(function(resolve, reject) {
                Upload.upload({
                    url: base_file_manager_url + '/upload',
                    data: {upload: files, type: type},
                }).then(function (resp) {
                    if (resp.data.status == 'successful') {
                        $scope.isLoading = false;
                        let upload = resp.data.upload;
                        resolve(upload);
                    } else {
                        $scope.isLoading = false;
                        toastr.error(messages.error);
                        reject(0);
                    }
                }, function (resp) {
                    $scope.isLoading = false;
                    toastr.error(messages.error);
                    reject(0);
                });
            });
        };


        $scope.uploadImages = async function (files) {
            if (files && files.length) {
                let count = 0;
                if ($scope.isCreating) {
                    count = files.length + $scope.ticket.files.length;
                } else {
                    count = files.length + $scope.question.files.length;
                }
                if (count > 5) {
                    toastr.error(messages.file_limit);
                    return false;
                }
                let images = null;
                try {
                    images = await $scope.uploads(files, 'ticket');
                } catch (error) {
                    toastr.error(messages.error);
                }
                for (let index = 0; index < images.length; index++) {
                    images[index] = images[index].replace(base_file_manager_url, "");   
                }
                if (images) {
                    $scope.$applyAsync(function () {
                        if ($scope.isCreating) {
                            $scope.ticket.files = $scope.ticket.files.concat(images);
                        } else {
                            $scope.question.files = $scope.question.files.concat(images);
                        }
                    });
                }
            }
        };

        $scope.getImageCdn = function ($url, $width = 0, $height = 0, $fitIn = true) {
            return $url;
            // return 0;
            if (!$url) return "";
            let retval;
            let originUrl = $url;
            if (originUrl.substr(0, 4) == 'http') {
                $url = $url.replace('https://', '');
                $url = $url.replace('http://', '');
            }
            // return $url;

            retval =  baseCdnUrl + "/" + $url;

            if ($width == 0 && $height == 0) {
                retval =  baseCdnUrl + "/" + $url;
            } else if ($width == 0 || $height == 0) {
                retval = baseCdnUrl + "/" + $width + "x" + $height + "/" + $url;
            } else {
                retval = baseCdnUrl + "/fit-in/" + $width + "x" + $height + "/filters:fill(fff)/" + $url;
            }
            return retval;
        }

        $scope.openOrderCode = function() {
            $scope.isOpenOrderCode = false;
            $scope.ticket.order_code = "";
            $scope.message.type = "";
            $scope.message.order_code = "";
            if ($scope.ticket.type == "change_order" ||
                $scope.ticket.type == "tracking_code" ||
                $scope.ticket.type == "cancel_order" ||
                $scope.ticket.type == "order" ||
                $scope.ticket.type == "claim_paypal" ||
                $scope.ticket.type == "unhappy_customer"
            ) {
                $scope.isOpenOrderCode = true;
            }
        }

        $scope.viewTicket = function(ticket) {
            $scope.isCreating = false;
            $scope.isViewTicket = true;
            $scope.currentTicket = angular.copy(ticket);
            $scope.question = {
                ticket_id: '',
                content: '',
                files: [],
                type: ""
            }
            $("html, body").animate({ scrollTop: 0 }, "slow");
        }

        $scope.closeViewTicket = () => {
            $scope.isCreating = false;
            $scope.isViewTicket = false;
            $scope.currentTicket = {
                customer_token: '',
                title: '',
                email: '',
                content: '',
                files: [],
                type: "",
                created_at: "",
            };
        }

        $scope.change = (key) => {
            $scope.message[key] = "";
        }

        $scope.sendQuestion = () => {
            if (!$scope.question.content) {
                $scope.messageQuestion["content"] = messages["required"]["content"];
                return;
            }
            $scope.isLoading = true;
            let data = {
                ticket_id: $scope.currentTicket.id,
                content: $scope.question.content,
                files: JSON.stringify($scope.question.files),
            };
            $http.post('/ticket/send-question', data)
                .then(function (response) {
                    $scope.isLoading = false;
                    toastr.success(messages['successQuestion']);
                    let result = response.data.result;
                    result.files = JSON.parse(result.files);
                    $scope.currentTicket.ticket_items.push(result);

                    $scope.question = {
                        ticket_id: '',
                        content: '',
                        files: [],
                        type: ""
                    }
                }, function (error) {
                    toastr.error(messages['error']);
                    $scope.isLoading = false;
                });
        }

        $scope.removeImage = (url, type) => {
            if (type == 'ticket') {
                $scope.ticket.files = $scope.ticket.files.filter(i => i != url);
            } else if (type == 'question') {
                $scope.question.files = $scope.question.files.filter(i => i != url);
            }
        }
        $scope.changeClass = function(name) {
            $scope.activeSelected = name;
        }

        $scope.showEmail = function(email) {
            if (email == null || email == '') {
                return email;
            }
            var arr = email.split("@");
            var letter1 = arr[0][0] + "*".repeat(arr[0].length - 2) + arr[0].slice(-1);
            return letter1 + "@" + arr[1];
        }

        $scope.showName = function (string) {
            var retVal = 'C';
            if (string != null && string != '') {
                retVal = string.charAt(0);
            }
            return retVal;
        }
        $scope.init();
    });
</script>
