@extends('layouts.master')
@section('css')
    <link rel="stylesheet" href="{{ asset('modules/ticket/css/ticket.css') }}?v=<?= time() ?>">
@append

@section('main')
<div ng-app="myApp" ng-cloak>
    <div ng-controller="TicketController">
        <div class="site-w my-ticket">
            <div class="ticket-title" ng-show="!isViewTicket">
                <p class="how">{{ __('How can we help you?') }}</p>
                <p>{{ __('Send us a ticket if you have compliments, concerns or questions.') }}</p>
                <p>{{ __('We are happy to help!') }}</p>
                <p style="color: red">{{ __('All questions are answered within 12 working hours!') }}</p>
            </div>
            <div class="ticket-navigation flex-b align-c" ng-show="!isViewTicket">
                <div class="ticket-head-box flex-b align-c">
                    <button ng-click="create()" type="submit" class="ticket-button create-ticket flex-b align-c" id="new-contact" ng-show="!isViewTicket">
                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                            <path d="M8 0a1 1 0 0 1 1 1v6h6a1 1 0 1 1 0 2H9v6a1 1 0 1 1-2 0V9H1a1 1 0 0 1 0-2h6V1a1 1 0 0 1 1-1z"/>
                        </svg>
                        {{ __('Create New Ticket') }}
                    </button>
                    <div class="ticket-filter-wrapper" ng-show="!isViewTicket">
                        <span class="ticket-filter-current flex-b align-c flex-c">
                            {{ __('Ticket status')}}
                        </span>
                        <div class="ticket-filter">
                            <div class="ticket-filter-item" ng-click="meta.page_id = 0; find('all')">
                                {{ __('All') }}
                            </div>
                            <div class="ticket-filter-item" ng-click="meta.page_id = 0; find('open')">
                                {{ __('Open') }}
                            </div>
                            <div class="ticket-filter-item" ng-click="meta.page_id = 0; find('close')">
                                {{ __('Closed') }}
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="pagination-list flex-b flex-e align-c" ng-show="!isViewTicket && meta.page_count > 1">
                    <li ng-if="meta.page_count > 1 && meta.page_id > 0">
                        <a href="javascript:;" ng-click="meta.page_id = meta.page_id - 1; find(type)">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/>
                            </svg>
                        </a>
                    </li>
                    <li ng-if="meta.page_count > 1 && meta.page_id > 0">
                        <a href="javascript:;" ng-click="meta.page_id = meta.page_id - 1; find(type)">@{{ meta.page_id }}</a>
                    </li>
                    <li>
                        <a href="javascript:;">@{{ meta.page_id + 1 }}</a>
                    </li>
                    <li ng-if="meta.page_count > 1 && meta.page_id < meta.page_count - 1" class="active">
                        <a href="javascript:;" ng-click="meta.page_id = meta.page_id + 1; find(type)">@{{ meta.page_id + 2 }}</a>
                    </li>
                    <li ng-if="meta.page_count > 1 && meta.page_id < meta.page_count - 1">
                        <a href="javascript:;" ng-click="meta.page_id = meta.page_id + 1; find(type)">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
                            </svg>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="flex-b align-c flex-c flex-dc" ng-show="openTickets.length == 0 && !isViewTicket">
                <p>{{ __("You don't have any open tickets") }}</p>
            </div>
            <div class="" ng-show="openTickets.length > 0 && !isViewTicket">
                <div class="tickets ticket-heading">
                    <div class="ticket-item">
                        <div class="item-user">
                            {{ __('Customer')}}
                        </div>
                        <div class="item-subject">
                            {{ __('Subject')}}
                        </div>
                        <div class="item-assignee">
                            {{ __('Order code')}}
                        </div>
                        <div class="item-assignee">
                            {{ __('Supporter')}}
                        </div>
                        <div class="item-status">
                            {{ __('Status')}}
                        </div>
                        <div class="item-time">
                            {{ __('Last message')}}
                        </div>
                    </div>
                </div>
            </div>
            <div id="open-tickets" class="tab-pane" ng-show="openTickets.length > 0 && !isViewTicket">
                <div class="tickets ticket-content" ng-show="openTickets.length > 0 && !isViewTicket && !isLoading">
                    <div class="ticket-item" ng-repeat="item in openTickets track by $index">
                        <div class="item-user flex-b align-c">
                            <div class="ticket-avata is-desktop">
                                <span style="text-transform: capitalize;">
                                    @{{ item.email.charAt(0) }}
                                </span>
                            </div>
                            <div class="ticket-user">
                                <span class="user-email" ng-if="item.customer_name == ''" title="@{{ item.email }}">
                                    @{{ showEmail(item.email) }}
                                </span>
                                <span class="user-email" ng-if="item.customer_name != ''">
                                    @{{ item.customer_name }}
                                </span>
                                <a class="view-ticket-large" href="<?= clroute('/contact/ticket?id={{ item.id }}') ?>">
                                    {{ __('View Ticket') }}
                                </a>
                            </div>
                        </div>
                        <div class="item-subject">
                            <a class="link-title" href="<?= clroute('/contact/ticket?id={{ item.id }}') ?>">
                                @{{ item.title }}
                            </a>
                        </div>
                        <div class="item-assignee">
                            @{{ item.order_code }}
                        </div>
                        <div class="item-assignee">
                            {{ config('app.name') }}
                        </div>
                        <div class="item-status">
                            <span class="status-open" ng-show="item.status == 'open' || item.status == 'waiting_third_party' || item.status == 'waiting_customer'">{{ __('Open')}}</span>
                            <span class="status-close" ng-show="item.status == 'close'">{{ __('Close')}}</span>
                        </div>
                        <div class="item-time">
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="is-mobile" viewBox="0 0 16 16">
                                <path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71V3.5z"/>
                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0z"/>
                            </svg>
                            <span>
                                @{{ toUsDate(item.created_at) }}
                            </span>
                            <a class="view-ticket-small" href="<?= clroute('/contact/ticket?id={{ item.id }}') ?>">
                                {{ __('View Ticket') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="new-ticket @{{ isCreating ? ' show' : '' }}" ng-show="isCreating">
                <div class="new-ticket-content">
                    <h3 class="ticket-label flex-b align-c">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                            <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                            <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                        </svg>
                        {{ __('New Ticket')}}
                    </h3>
                    <div class="content-fixpage request-form">
                        <div class="product-variant-box product-variant-item-box">
                            <label class="product-variant-heading">{{ __('Your email address') }}</label>
                            <input type="text" class="form-control" name="email" id="email" autocomplete="off" ng-model="ticket.email" placeholder="{{ __('Your email address') }}" ng-change="change('email')">
                            <p class="small error error-require-email" ng-if="message.email">@{{ showEmail(message.email) }}</p>
                        </div>
                        <div class="product-variant-box product-variant-item-box">
                            <label class="product-variant-heading">{{ __('Your name') }}</label>
                            <input type="text" class="form-control" name="name" id="customer_name" autocomplete="off" ng-model="ticket.customer_name" placeholder="{{ __('Your name') }}" ng-change="change('customer_name')">
                            <p class="small error error-require-email" ng-if="message.customer_name">@{{ message.customer_name }}</p>
                        </div>
                        <div class="product-variant-box product-variant-item-box">
                            <label class="product-variant-heading">{{ __('Subject') }}</label>
                            <input type="text" class="form-control" name="title" id="title" ng-model="ticket.title" placeholder="{{ __('Subject') }}" ng-change="change('title')">
                            <p class="small error error-require-title" ng-if="message.title">@{{ message.title }}</p>
                        </div>
                        <div class="product-variant-box product-variant-item-box">
                            <label class="product-variant-heading">{{ __('Ticket Type') }}</label>
                            <select class="form-control" ng-model="ticket.type" ng-options="type.key as type.value for type in types" ng-change="openOrderCode()">
                            </select>
                            <p class="small error error-require-title" ng-if="message.type">@{{ message.type }}</p>
                        </div>
                        <div class="product-variant-box product-variant-item-box" ng-if="isOpenOrderCode">
                            <label class="product-variant-heading">{{ __('Order Code') }}</label>
                            <input type="text" class="form-control" name="order_code" id="order_code" ng-model="ticket.order_code" placeholder="{{ __('Please Enter Order Code') }}" ng-change="change('order_code')">
                            <p class="small error error-require-title" ng-if="message.order_code">@{{ message.order_code }}</p>
                        </div>
                        <div class="form-group">
                            <label class="product-variant-heading">{{ __('How can we help you?') }}</label>
                            <div class="form-text-area">
                                <textarea class="form-control" name="description" id="description" rows="3" ng-model="ticket.content" placeholder="{{ __('How can we help you?') }}" ng-change="change('content')"></textarea>
                            </div>
                            <p class="small error error-require-description" ng-if="message.content">@{{ message.content }}</p>
                        </div>
                        <div class="product-variant-box product-variant-item-box">
                            <div class="small">{{ __('If you have a photo or image that will help our investigation, please add it here.') }}</div>
                            <label class="ticket-file-selector flex-b align-s" for="selectImages">
                                <div class="select-images-note flex-b align-c flex-c">{{ __('Add photo (max. 5)')}}</div>
                                <div class="button dark" id="selectImagesButton">
                                    <span class="is-mobile">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-camera" viewBox="0 0 16 16">
                                            <path d="M15 12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h1.172a3 3 0 0 0 2.12-.879l.83-.828A1 1 0 0 1 6.827 3h2.344a1 1 0 0 1 .707.293l.828.828A3 3 0 0 0 12.828 5H14a1 1 0 0 1 1 1v6zM2 4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1.172a2 2 0 0 1-1.414-.586l-.828-.828A2 2 0 0 0 9.172 2H6.828a2 2 0 0 0-1.414.586l-.828.828A2 2 0 0 1 3.172 4H2z"></path>
                                            <path d="M8 11a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5zm0 1a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7zM3 6.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0z"></path>
                                        </svg>
                                    </span>
                                    <span class="is-desktop">
                                        {{ __('Choose photo')}}
                                    </span>
                                </div>
                                <input ngf-select="uploadImages($files)" accept="image/*" id="selectImages" multiple="" style="display: none" type="file">
                            </label>

                            <div class="ticket-images">
                                <div class="img-item" ng-repeat="url in ticket.files">
                                    <img src="@{{ getImageCdn(url, 200, 200) }}" alt="">
                                    <span ng-click="removeImage(url, 'ticket')">
                                        &times;
                                    </span>
                                </div>
                            </div>
                            <p class="small error error-require-title" ng-if="message.file_limit">@{{ message.file_limit }}</p>
                        </div>
                        <div class="form-group action-button flex-b flex-e align-c">
                            <button class="button-simple" ng-click="cancel()">
                                {{ __('Cancel') }}
                            </button>
                            <button class="btn-hilight-color btn-loading-progess btn-submit" ng-click="save()" ng-disabled="isLoading">
                                <span ng-if="isLoading">
                                    <img src="{{ Module::asset('ticket/images/loading.gif') }}" alt="" style="height: 22px;">
                                </span>
                                <span ng-if="!isLoading">
                                    {{ __('Submit') }}
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="new-ticket-background" ng-click="cancel()"></div>
            </div>

            <!-- Ticket details -->
            <div class="ticket-detail @{{ isViewTicket ? 'show' : '' }}" ng-show="isViewTicket">
                <div class="question flex-b flex-dc">
                    <div class="">
                        <div class="question-head">
                            @{{ currentTicket.title }}
                        </div>
                        <ul class="breadcrumb">
                            <li>
                                <a href="<?= clroute('/') ?>">{{ __('Home')}}</a>
                            </li>
                            <li>
                                <a href="<?= clroute('/contact/ticket')?> ">{{ __('Ticket')}}</a>
                            </li>
                            <li>
                                <span>@{{ currentTicket.title }}</span>
                            </li>
                        </ul>
                        <div class="ticket-status-wrapper flex-b align-s">
                            <div class="ticket-status-item ticket-id">
                                {{ __('Ticket ID')}}
                                <span>#@{{ currentTicket.id }}</span>
                            </div>
                            <div class="ticket-status-item ticket-status">
                                {{ __('Status')}}
                                <span ng-if="currentTicket.status == 'open' || currentTicket.status == 'waiting_third_party' || currentTicket.status == 'waiting_customer'" style="color: #0d6efd;">{{ __('Open') }}</span>
                                <span ng-if="currentTicket.status == 'close'">{{ __('Close') }}</span>
                            </div>
                            <div class="ticket-status-item ticket-time">
                                {{ __('Created')}}
                                <span>@{{ toUsDate(currentTicket.created_at) }}</span>
                            </div>
                            <div class="ticket-status-item ticket-product">
                                {{ __('Order code')}}
                                <span>@{{currentTicket.order_code}}</span>
                            </div>
                            <div class="ticket-status-item ticket-type">
                                {{ __('Ticket Type')}}
                                <span>@{{currentTicket.type}}</span>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="list-answer">
                    <div class="answer-item @{{ ticketItem.type == 'customer' ? 'child-question-item' : 'child-answer-item'}}" ng-if="currentTicket.ticket_items.length > 0" ng-repeat="ticketItem in currentTicket.ticket_items track by ticketItem.id" >
                        <div ng-if="ticketItem.type == 'customer'"  class="ticket-item-avatar customer-avatar">
                            <span ng-show="currentTicket.customer_name != null">@{{ showName(currentTicket.customer_name) }}</span>
                            <span ng-show="currentTicket.customer_name == null">@{{ showName(currentTicket.email) }}</span>
                        </div>
                        <div ng-if="ticketItem.type !== 'customer'" class="ticket-item-avatar printerval-avatar">
                            <picture>
                                <source media="(min-width: 370px)" srcset="{{ getImageCdn('https://printerval.com/images/official.png', 80, 80, false) }}" />
                                <source media="(min-width: 320px)" srcset="{{ getImageCdn('https://printerval.com/images/official.png', 40, 40, false) }}" />
                                <source src="/images/blank.gif" />
                                <img src="/images/blank.gif" alt="<?= sprintf( __('Reply by %s'), 'Printerval') ?>"/>
                            </picture>
                        </div>

                        <div class="ticket-item-content">
                            <div class="item-answer-user align-c">
                                <span class="answer-name" ng-if="ticketItem.user_id">
                                    {{ config('app.name') }}
                                </span>
                                <span class="answer-email" ng-if="!ticketItem.user_id && currentTicket.customer_name != ''">
                                    @{{ currentTicket.customer_name }}
                                </span>

                                <span class="answer-email" ng-if="!ticketItem.user_id && currentTicket.customer_name == ''">
                                    @{{ showEmail(currentTicket.email) }}
                                </span>
                                <span class="answer-time">@{{ toUsDate(ticketItem.created_at) }}</span>
                            </div>

                            <div class="item-content" ng-bind-html="displayContent(ticketItem.content)"></div>
                            <div class="ticket-images" ng-if="ticketItem.files.length > 0">
                                <div class="img-item" ng-repeat="url in ticketItem.files track by $index">
                                    <img src="@{{ getImageCdn(url, 0, 300) }}" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <fieldset id="close-wrapper" class="answer-wrapper" ng-show="isViewTicket && currentTicket.status == 'close'">
                <div class="question-heading status-closed">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                        <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                        <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                    </svg>
                    <div class="">
                        <span>{{ __('Ticket is closed')}}</span>
                        <small>{{ __('Please open a new ticket for further assistance.')}}</small>
                    </div>
                </div>
            </fieldset>
            <fieldset id="answer-wrapper" class="answer-wrapper active" ng-show="isViewTicket && (currentTicket.status == 'open' || currentTicket.status == 'waiting_third_party' || currentTicket.status == 'waiting_customer')">
                <legend class="question-heading">{{ __('How can we help you?') }}</legend>
                <div class="customer-question-wrapper" style="display: block;">
                    <div class="form-group">
                        <div class="form-text-area">
                            <textarea class="form-control" name="description" id="description" rows="4" ng-model="question.content" placeholder="{{ __('For now, please enter your questions.') }}"></textarea>
                        </div>
                        <p class="small error error-require-description" ng-if="messageQuestion.content">@{{ messageQuestion.content }}</p>
                    </div>
                    <div class="small" style="padding: 0">{{ __('If you have a photo or image that will help our investigation, please add it here.') }}</div>
                    <label class="ticket-file-selector flex-b align-s" for="selectImages">
                        <div class="select-images-note flex-b align-c flex-c">{{ __('Add photo (max. 5)')}}</div>
                        <div class="button dark" id="selectImagesButton" style="margin-right: 0">
                            <span class="is-mobile">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-camera" viewBox="0 0 16 16">
                                    <path d="M15 12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h1.172a3 3 0 0 0 2.12-.879l.83-.828A1 1 0 0 1 6.827 3h2.344a1 1 0 0 1 .707.293l.828.828A3 3 0 0 0 12.828 5H14a1 1 0 0 1 1 1v6zM2 4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1.172a2 2 0 0 1-1.414-.586l-.828-.828A2 2 0 0 0 9.172 2H6.828a2 2 0 0 0-1.414.586l-.828.828A2 2 0 0 1 3.172 4H2z"></path>
                                    <path d="M8 11a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5zm0 1a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7zM3 6.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0z"></path>
                                </svg>
                            </span>
                            <span class="is-desktop">
                                {{ __('Choose photo')}}
                            </span>
                        </div>
                        <input ngf-select="uploadImages($files)" accept="image/*" id="selectImages" multiple="" style="display: none" type="file">
                    </label>
                    <div class="ticket-images">
                        <div class="img-item comment-img" ng-repeat="url in question.files">
                            <img class="img-item" src="@{{ getImageCdn(url, 0, 200) }}" alt="">
                            <span ng-click="removeImage(url, 'question')">
                                &times;
                            </span>
                        </div>
                    </div>
                    <div class="small error error-require-title" ng-if="message.file_limit">@{{ message.file_limit }}</div>
                    <div class="flex-b align-c">
                        <button ng-click="sendQuestion()" ng-disabled="isLoading" type="submit" class="button secondary">
                            {{ __('Save') }}
                        </button>
                        <!-- <button ng-click="closeCreateNewQuestion()" type="submit" class="button light">
                            {{ __('Cancel') }}
                        </button> -->
                    </div>
                </div>
            </fieldset>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="{{ Module::asset('ticket/js/bootstrap.min.js') }}?v={{ config('sa.version') }}"></script>
<script src="{{ Module::asset('ticket/js/angular.min.js') }}?v={{ config('sa.version') }}"></script>
<script src="{{ Module::asset('ticket/js/angular-sanitize.min.js') }}?v={{ config('sa.version') }}"></script>
<script src="{{ Module::asset('ticket/js/ng-file-upload-shim.min.js?') }}v={{ config('sa.version') }}"></script>
<script src="{{ Module::asset('ticket/js/ng-file-upload.min.js') }}?v={{ config('sa.version') }}"></script>
@include('ticket::frontend.ticket-script')
<script type="text/javascript">
    $('.ticket-filter-item').click (function () {
        var filterText = $(this).text();
        $('.ticket-filter-current').text(filterText);
        $(this).addClass('active').siblings().removeClass('active');
    })
</script>
@append
