@extends('system.layout.main')
@section('title')
<title>Cấu hình nhân viên xử lý Ticket</title>
@endsection
@section('css')
<style media="screen">
    .header {
        margin-bottom: 25px;
    }

    .import-export a {
        color: #637381;
        padding: 7px 10px;
        margin-left: -7px;
        font-size: 15px;
        font-weight: 300;
        margin-right: 15px;
    }

    .import-export a:hover {
        background-color: #ccc;
        border-radius: 3px;
    }

    button.add {
        margin-top: 30px;
    }
    .product-item {
        cursor: pointer;

    }

    .product-item .view-product{
        display: none;
    }
    .product-item:hover .view-product{
        display: block;
    }
    .box-body {
        overflow: unset;
    }

    .py-10 {
        padding: 10px 0;
    }

    textarea.disable {
        background-color: #fff !important;
        cursor: default !important;
    }
    .group-first {
        padding: 0 !important;
        vertical-align: bottom !important;
    }
    .group-second {
        vertical-align: top !important;
        padding: 0 !important;
    }

    .in-group {
        border-left: 4px solid black;
    }

    .item-img {
        width: 70px;
        height: 70px;
        display: inline-block;
        padding: 5px;
        max-width: calc(20vw - 12px);
        max-height: calc(20vw - 12px);
        position: relative;
    }

    .item-img img {
        width: 100%;
    }

    .comment-image {
        padding: 2px;
        border: 1px solid #bfbfbf;
        margin-right: 3px;
        border-radius: 5px;
    }

    .sb_image {
        position: relative;
    }

    .sb_image:hover .middle {
        opacity: 1;
    }

    .middle {
        transition: .5s ease;
        opacity: 0;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        -ms-transform: translate(-50%, -50%);
        text-align: center;
        width: 100%;
    }
    td.vertical-align-top {
        vertical-align: top !important;
    }
    .hour-input {
        border: 1px solid #ced4da;
        height: 30px;
        width: 45px;
        border-radius: 3px;
        padding: 0 0 0 10px;
    }
    .chosen-container {
        width: 100%!important;
    }
    .chosen-container > .chosen-choices {
            line-height: 34px;
    }

   .chosen-container > .chosen-choices {
            border-radius: 3px !important;
            height: 34px !important;
            border: 1px solid #ced4da;
    }
    .search-field > input {
        width: 100%!important;
    }
</style>
@endsection
@section('script')
<script>
    $('#filter > button').on('click', function(event) {
        $(this).parent().toggleClass('open');
    });
    $('body').on('click', function(e) {
        if (!$('#filter').is(e.target) &&
            $('#filter').has(e.target).length === 0 &&
            $('.open').has(e.target).length === 0
        ) {
            $('#filter').removeClass('open');
        }
    });
</script>
<script>
    var users = <?= json_encode($users) ?>;
    var locates = <?= json_encode($locates) ?>;
</script>
<script src="" charset="utf-8"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('ticket/js/ticket-config-controller.js') }}?v=<?= Config::get("sa.version") ?>"></script>
@endsection
@section('content')
<div class="content" ng-controller="TicketConfigController" id="TicketController">
    <div class="header">
        <div class="pull-left">
            <h3 class="">Cấu hình nhân viên xử lý Ticket</h3>
        </div>
        <?php 
            if (hasPermission('view_ticket_management')) {
         ?>
            <button 
                type="button" 
                name="button" 
                class="btn btn-success  pull-right"
                style="margin-top: 20px;"
                ng-click="openModal(null, 'create')"
            >
                <i class="fa fa-plus"></i> Thêm cấu hình
            </button>
            <?php } ?>
        <div class="clearfix">
        </div>
    </div>
    <div class="body">
        <div class="box no-border">
            <!-- /.box-header -->
            <div class="box-body" style="margin-bottom: 10px;">
                <div class="row">
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-change="find(true)" ng-model="filter.user_id" ng-options="key as value for (key, value) in users">
                            <option value="">-- Chọn nhân viên --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-change="find(true)" ng-model="filter.locate" ng-options="key as value for (key, value) in locates">
                            <option value="">-- Chọn thị trường --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-change="find(true)" ng-model="filter.status" ng-options="key as value for (key, value) in statusses">
                            <option value="">-- Chọn trạng thái --</option>
                        </select>
                    </div>
                </div>
                <div class="row py-10">
                    <div class="col-md-12">
                        <button type="button" class="btn btn-primary " ng-click="find()">
                            <i class="fa fa-search"></i>
                            Tìm kiếm
                        </button>
                        <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                            <i class="fa fa-refresh"></i>
                            Xóa form
                        </button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Nhân viên</th>
                                        <th>Trạng thái</th>
                                        <th>Thị trường</th>
                                        <th>Số Ticket đang xử lý</th>
                                        <th>Ngày / Giờ làm việc</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody class="striped-row">
                                    <tr  ng-repeat="item in items" ng-if="items.length && !isLoading">
                                        <td>
                                            @{{$index + 1}}
                                        </td>    
                                        <td>
                                           @{{users[item.user_id]}}
                                        </td>
                                        <td>
                                            <span ng-show="item.status == 'active'">
                                                <small class="badge" style="background-color: #00a65a;">
                                                    Hoạt động
                                                </small> 
                                            </span>
                                            <span ng-show="item.status == 'inactive'">
                                                <small class="badge" style="background-color: #dd4b39;">
                                                        Dừng hoạt động
                                                </small> 
                                            </span>
                                            <span ng-show="item.status == 'quit_job'">
                                                <small class="badge" style="background-color: #d2d6de;">
                                                        Nghỉ việc
                                                </small> 
                                            </span>
                                        </td>
                                        <td>
                                            <div style="padding: 0; text-align: left; width: 30px;">
                                                <img src="/modules/localization/images/@{{item.locate}}.svg" style="max-width:25px; border-radius: 0px;" ng-show="item.locate != null && item.locate != ''"/>
                                            </div>
                                        </td>
                                        <td>
                                            @{{item.number_ticket_open}}
                                        </td>
                                        <td>
                                            <span ng-repeat="day in item.days"><i>@{{dayOfWeeks[day]}}, </i></span>
                                            </br>
                                            Từ @{{item.from_hours}}:00 - đến @{{item.to_hours}}:00
                                        </td>
                                        <td>
                                        <?php 
                                            if (hasPermission('view_ticket_management')) {
                                        ?>
                                                <button class="btn btn-primary" title="Xem chi tiết" ng-click="openModal(item, 'update')">
                                                    Chi tiết
                                                </button>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr ng-if="items.length == 0 && !isLoading">
                                        <td colspan="6">Không có cấu hình nào</td>
                                    </tr>
                                    <tr ng-if="isLoading">
                                        <td colspan="6" class="text-center">
                                            <div class="empty-contain flex-box align-c flex-c">
                                                <img src="/images/loading.gif" alt="">
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                @include('system.pagination')
            </div>
        </div>
    </div>
    @include('ticket::system.config-job.modal')
</div>
@endsection
