@extends('system.layout.main')
@section('title')
<title>Help Central</title>
@endsection
@section('css')
<style media="screen">
    .header {
        margin-bottom: 25px;
    }

    .import-export a {
        color: #637381;
        padding: 7px 10px;
        margin-left: -7px;
        font-size: 15px;
        font-weight: 300;
        margin-right: 15px;
    }

    .import-export a:hover {
        background-color: #ccc;
        border-radius: 3px;
    }

    button.add {
        margin-top: 30px;
    }
    .product-item {
        cursor: pointer;

    }

    .product-item .view-product{
        display: none;
    }
    .product-item:hover .view-product{
        display: block;
    }
    .box-body {
        overflow: unset;
    }

    .py-10 {
        padding: 10px 0;
    }

    textarea.disable {
        background-color: #fff !important;
        cursor: default !important;
    }
    .group-first {
        padding: 0 !important;
        vertical-align: bottom !important;
    }
    .group-second {
        vertical-align: top !important;
        padding: 0 !important;
    }

    .in-group {
        border-left: 4px solid black;
    }

    .item-img {
        width: 70px;
        height: 70px;
        display: inline-block;
        padding: 5px;
        max-width: calc(20vw - 12px);
        max-height: calc(20vw - 12px);
        position: relative;
    }

    .item-img img {
        width: 100%;
    }

    .comment-image {
        padding: 2px;
        border: 1px solid #bfbfbf;
        margin-right: 3px;
        border-radius: 5px;
    }

    .sb_image {
        position: relative;
    }

    .sb_image:hover .middle {
        opacity: 1;
    }

    .middle {
        transition: .5s ease;
        opacity: 0;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        -ms-transform: translate(-50%, -50%);
        text-align: center;
        width: 100%;
    }
    td.vertical-align-top {
        vertical-align: top !important;
    }
</style>
@endsection
@section('script')
<script>
    $('#filter > button').on('click', function(event) {
        $(this).parent().toggleClass('open');
    });
    $('body').on('click', function(e) {
        if (!$('#filter').is(e.target) &&
            $('#filter').has(e.target).length === 0 &&
            $('.open').has(e.target).length === 0
        ) {
            $('#filter').removeClass('open');
        }
    });
</script>
<script>
    var base_api_url = '{{ config('ticket::sa.api_url')}}';
    var email = "{{ app('request')->query('email') }}";
    var ticketUsers = <?= json_encode($users) ?>;
    var userId = '<?= \Auth::user()->id?>';
    var siteUrl = "{{ config('ticket::sa.file_manager_url')}}"
    var locates = <?= json_encode($locates) ?>;
    var id = "<?= isset($_GET['id']) ? $_GET['id'] : null?>";
    var changeOrder = "<?= isset($_GET['change_order']) ? $_GET['change_order'] : null ?>"
</script>
<script src="" charset="utf-8"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="/system/js/scripts/ckeditor/ckeditor.js" charset="utf-8"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script type="text/javascript" src="{{ Module::asset('ticket/js/vi.js') }}?v=<?= Config::get("sa.version") ?>"></script>
<script type="text/javascript" src="{{ Module::asset('ticket/js/ticket-controller.js') }}?v=<?= Config::get("sa.version") ?>"></script>
@endsection
@section('content')
<div class="content" ng-controller="TicketController" id="TicketController">
    <div class="header">
        <div class="pull-left">
            <h3 class="">Trung tâm trợ giúp khách hàng</h3>
        </div>
        <button 
                type="button" 
                name="button" 
                class="btn btn-success pull-right"
                style="margin-top: 20px;"
                ng-click="edit('create')"
            >
                <i class="fa fa-fw fa-send-o"></i> <b>Tạo ticket mới</b>
        </button>
        <div class="clearfix">
        </div>
    </div>
    <div class="body">
        <div class="box no-border">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                    <li class="all-item">
                        <a href="javascript:void(0)" style="cursor: pointer">
                            Tìm kiếm Ticket
                        </a>
                    </li>
                    <li class="float-right">
                        <a class="command-link" href="javascript:void(0)" ng-click="switchMode('narrow')" ng-show="modeShowFilter == 'expand'"><i class="fa fa-angle-up"></i> Thu hẹp</a>
                        <a class="command-link" href="javascript:void(0)" ng-click="switchMode('expand')" ng-show="modeShowFilter == 'narrow'"><i class="fa fa-angle-down"></i> Mở rộng</a>
                    </li>
                </ul>
            </div>
            <!-- /.box-header -->
            <div class="box-body" style="margin-bottom: 10px;">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" class="form-control" placeholder="Tiêu đề Ticket, tên, email khách hàng, mã đơn hàng" ng-model="filter.keyword"  ng-keydown="$event.keyCode === 13 && find(true)">
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.type" ng-options="key as value for (key, value) in types" ng-change="find(true)">
                            <option value="">-- Chọn loại Ticket --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.status" ng-options="key as value for (key, value) in statuses" ng-change="find(true)">
                            <option value="">-- Trạng thái --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.is_reply" ng-options="key as value for (key, value) in reply" ng-change="find(true)">
                            <option value="">-- Chọn trả lời  --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.order" ng-options="key as value for (key, value) in orders" ng-change="find(true)">
                            <option value="">-- Sắp xếp --</option>
                        </select>
                    </div>
                </div>
                <div class="row" style="margin-top: 10px;" ng-if="modeShowFilter == 'expand'">
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.locate" ng-options="key as value for (key, value) in locates" ng-change="find(true)">
                            <option value="">-- Thị trường --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.user_id" ng-options="key as value for (key, value) in users" ng-change="find(true)">
                            <option value="">-- Nhân viên xử lý --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="" class="form-control" ng-model="filter.from" ng-options="key as value for (key, value) in froms" ng-change="find(true)">
                            <option value="">-- Nguồn tạo ticket --</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label>
                            <input type="checkbox"
                                ng-change="find()"
                                ng-true-value="1" ng-false-value="0"
                                ng-model="filter.is_spam"/>
                                Ticket Spam
                        </label>
                    </div>
                </div>
                <div class="row" style="margin-top: 10px;">
                    <div class="col-md-4">
                        <button type="button" class="btn btn-primary " ng-click="find(true)">
                            <i class="fa fa-search"></i>
                            Tìm kiếm
                        </button>
                        <button type="button" class="btn btn-default ml-3 " ng-click="clear()">
                            <i class="fa fa-refresh"></i>
                            Xóa form
                        </button>
                    </div>
                </div>
                <div class="row py-10">
                    <div class="col-md-6">
                        <h5>Danh sách Ticket 
                            <a href="#" 
                            ng-click="filterTicketHandleByUser()" 
                            style="color: red"
                            ng-if="ticketsHandleByCurrentUser > 0">
                            ( Bạn có @{{ticketsHandleByCurrentUser}} ticket cần xử lý )
                            </a>
                            <span
                            ng-if="isShowTicketsHandleByCurrentUser && userId == filter.user_id && filter.status !== 'close'">
                            bạn cần xử lý
                            </span>
                        </h5>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <!-- <div class="table-responsive"> -->
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <?php 
                                            if (hasPermission('view_ticket_management')) {
                                        ?>
                                        <th>
                                            <input type="checkbox"
                                                ng-change="checkAll()" 
                                                ng-true-value="1" ng-false-value="0"
                                                ng-model="checkedAll"
                                                ng-disabled="isLoading"
                                                style="margin-bottom: 5px;"
                                            />
                                        </th>
                                        <?php 
                                            }
                                        ?>
                                        <th ng-show="countSelected == 0">Trạng thái</th>
                                        <th ng-show="countSelected == 0">Ngày tạo / cập nhật</th>
                                        <th ng-show="countSelected == 0">Khách hàng</th>
                                        <th ng-show="countSelected == 0">Mô tả ngắn</th>
                                        <th ng-show="countSelected == 0" ></th>
                                        <th ng-show="countSelected > 0" colspan="5">
                                            <div class="btn-group" style="position: inherit;">
                                                <a href="javascript:;" class="btn btn-default" ng-show="countSelected > 0" ng-click="updateMultiItem()" data-toggle="tooltip" title="Cập nhật ticket đã chọn">
                                                    <i class="fa fa-fw fa-gear"></i>
                                                </a>
                                                <a href="javascript:;" ng-show="filter.is_spam === 0" class="btn btn-default" ng-show="countSelected > 0" ng-click="updateEmailSpam()" data-toggle="tooltip" title="Báo cáo spam">
                                                    <i class="fa fa-fw fa-exclamation-circle"></i>
                                                </a>
                                                <a href="javascript:;" ng-show="filter.is_spam" class="btn btn-default" ng-show="countSelected > 0" ng-click="updateEmailNotSpam()" data-toggle="tooltip" title="Ticket không phải spam">
                                                    <i class="fa fa-fw fa-refresh"></i>
                                                </a>
                                                <a href="javascript:;" class="btn btn-default" ng-show="countSelected > 0" ng-click="settingFilter()" data-toggle="tooltip" title="Bộ lọc spam">
                                                    <i class="fa fa-fw fa-filter"></i>
                                                </a>
                                            </div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="striped-row">
                                    <tr  ng-repeat="item in tickets" ng-if="tickets.length && !isLoading">
                                        <?php 
                                            if (hasPermission('view_ticket_management')) {
                                        ?>
                                            <td style="width: 40px;">
                                                <input type="checkbox"
                                                    ng-change="checkedItem()"
                                                    ng-true-value="1" ng-false-value="0"
                                                    ng-model="item.is_checked"/>
                                            </td>
                                        <?php 
                                            }
                                        ?>
                                        <td style="width: 80px;">
                                            <small class="badge"  ng-if="item.status == 'open'"style="background-color: #f39c12; width: 60px;text-transform: uppercase;">
                                                <span > Mở </span>
                                            </small> 
                                            <small class="badge"  ng-if="item.status == 'waiting_customer'"style="background-color: #00c0ef; width: 90px;text-transform: uppercase;">
                                                <span > Chờ khách </span>
                                            </small> 
                                            <small class="badge"  ng-if="item.status == 'waiting_third_party'"style="background-color: #00a65a; width: 100px;text-transform: uppercase;">
                                                <span > Chờ đối tác </span>
                                            </small> 
                                            <small class="badge" ng-if="item.status == 'close'" style="background-color: #b5bbc; width: 60px;text-transform: uppercase;">
                                                <span> Đóng </span>
                                            </small>
                                        </td>
                                        <td style="width: 200px;">
                                            <ul class="users-list clearfix">
                                                <li style="padding: 0; text-align: left; width: 25px;">
                                                    <img src="/modules/localization/images/@{{item.locate}}.svg" style="max-width:20px; border-radius: 0px;" ng-show="item.locate != null && item.locate != ''"/>
                                                </li>
                                                <li style="padding: 0; text-align: left; width: 25px;">
                                                    <img ng-show="item.from == 'customer'" src="/modules/ticket/images/customer.png" style="max-width:18px; border-radius: 0px;" data-toggle="tooltip" title="Ticket khách tạo trên website"/>
                                                    <img ng-show="item.from == 'email'" src="/modules/ticket/images/email.png" style="max-width:15px; border-radius: 0px;" data-toggle="tooltip" title="Ticket khách gửi vào Email"/>
                                                    <img ng-show="item.from == 'fulfillment'" src="/modules/ticket/images/staff.jpeg" style="max-width:18px; border-radius: 0px;"  data-toggle="tooltip" title="Ticket tạo từ yêu cầu của Fulfillment"/>
                                                </li>
                                            </ul>
                                            @{{ summarizeDateTime(item.created_at, true) }} 
                                            </br>
                                            @{{ summarizeDateTime(item.updated_at, true) }}
                                            </br ng-show="(item.user_id != null && item.user_id != '') || (item.locate == null || item.locate == '')">
                                            <div ng-show="item.user_id != null && item.user_id != ''">
                                                <b>@{{users[item.user_id]}}</b>
                                            </div>
                                            <div ng-show="item.locate == null || item.locate == ''">
                                                    <i>(Không tự động phát hiện được thị trường)</i>
                                            </div>
                                            </br>
                                            <div ng-show="item.deadline != null && item.deadline != ''" style="color: red;">
                                                Deadline: <b>@{{ summarizeDateTime(item.deadline_show) }}</b>
                                            </div>
                                        </td>
                                        
                                        <td style="width: 200px;">
                                                <b>@{{ item.customer_name }}</b>
                                                <br>
                                                <b>@{{ item.email }}</b>
                                            </br>
                                            <span ng-show="item.order_code != null && item.order_code != ''">
                                                Mã đơn: <b>@{{item.order_code}}</b>
                                            </span>
                                        </td>
                                        <td class="vertical-align-top" style="width: 550px; max-width: 550px;overflow-x: auto;">
                                            <p><small class="label label-info" style="text-transform: uppercase;">@{{types[item.type]}}</small> 
                                                <b ng-show="item.title != ''">@{{item.title}}</b>
                                            </p>
                                            <div ng-show="item.ticket_items.length > 0">
                                                <p>
                                                    <i class="fa fa-fw fa-comments-o" ng-show="item.ticket_items[0].type == 'customer'"></i>
                                                    <i ng-show="item.ticket_items[0].type == 'customer'">  Khách tạo @{{ calculateTimeAgo(item.ticket_items[0].created_at) }}</i>
                                                    <i class="fa fa-fw fa-comments" ng-show="item.ticket_items[0].type == 'staff'"></i>
                                                    <i ng-show="item.ticket_items[0].type == 'staff'">  @{{users[item.ticket_items[0].user_id]}} trả lời @{{ calculateTimeAgo(item.ticket_items[0].created_at) }}</i>
                                                </p>
                                                <div ng-bind-html="item.ticket_items[0].content | limitTo:item.strLimit"></div>
                                                <div class="pull-left">
                                                        <a class="command-link ng-hide" href="javascript:void(0)" ng-click="showMore(item, item.ticket_items[0].content)" ng-show="item.ticket_items[0].content.length > 150 && item.ticket_items[0].content.length != item.strLimit" style="" aria-hidden="true"><i class="fa fa-angle-down"></i> Xem thêm</a>
                                                        <a class="command-link" href="javascript:void(0)" ng-click="showLess(item)" ng-show="item.ticket_items[0].content.length == item.strLimit" style="" aria-hidden="false"><i class="fa fa-angle-up"></i> Thu lại</a>
                                                </div>
                                            </div>
                                            <div ng-show="item.ticket_items.length == 0">
                                                Note: @{{item.note}}
                                            </div> 
                                        </td>
                                        <td>
                                            <a href="javascript:void(0);" class="btn btn-primary" title="Xem chi tiết" ng-click="edit('update', item)">
                                                Chi tiết
                                            </a>
                                            <br>
                                            <div class="form-control" ng-show="item.ticket_order && item.ticket_order.ticket_related != null" style="margin-top:5px;"> 
                                                <a href="/tickets?id=@{{related_id}}" target="_blank" data-toggle="tooltip" ng-repeat="related_id in item.ticket_order.ticket_related" title="Ticket liên quan">
                                                    <i class="fa fa-ticket"></i>
                                                </a>
                                            </div>
                                            
                                        </td>
                                    </tr>
                                    <tr ng-if="tickets.length == 0 && !isLoading">
                                        <td colspan="6">Không có ticket nào</td>
                                    </tr>
                                    <tr ng-if="isLoading">
                                        <td colspan="6" class="text-center">
                                            <div class="empty-contain flex-box align-c flex-c">
                                                <img src="/images/loading.gif" alt="">
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        <!-- </div> -->
                    </div>
                </div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                @include('system.pagination')
            </div>
        </div>
    </div>
    @include('ticket::system.tickets.modal')
    @include('ticket::system.tickets.modal-action')
    @include('ticket::system.tickets.send-email')
    <script>
        (function() {
            var runMyCode = function($) {
                $(document).ready(function() {
                    $("body").tooltip({ selector: '[data-toggle=tooltip]' });
                });
            };

            var timer = function() {
                if (window.jQuery && window.jQuery.ui) {
                runMyCode(window.jQuery);
                } else {
                window.setTimeout(timer, 100);
                }
            };
            timer();
            })();
    </script>
</div>
@endsection
