<style>
    .custom-switch {
        padding-left: 2.25rem;
    }
    .custom-control {
        position: relative;
        z-index: 1;
        display: block;
        min-height: 1.5rem;
        padding-left: 1.5rem;
        -webkit-print-color-adjust: exact;
        color-adjust: exact;
    }
    .custom-control-input {
        position: absolute;
        left: 0;
        z-index: -1;
        width: 1rem;
        height: 1.25rem;
        opacity: 0;
    }
    .angular-with-newlines {
        white-space: pre-line;
    }
</style>
<div class="modal fade" id="modalForm" tabindex="-1">
    <div class="modal-dialog" style="width:100%;">
        <div class="modal-content" style="border-radius: 5px;">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <i class="fa fa-comments-o"></i>
                    <span>
                        Chủ đề: @{{ticket.title}}
                    </span>
                </h4>
                
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="box-header" style="color: #777;padding: 0 12px 0 0;">
                            <h5 class="box-title" style="font-size: 14px;"><small class="label label-info ng-binding" style="text-transform: uppercase;">@{{types[ticket.type]}}</small></h5>
                            <div class="box-tools" style="margin-top: 0;" ng-show="ticket.ticket_order && ticket.ticket_order.ticket_related != null"> 
                                (Ticket liên quan: 
                                <a href="/tickets?id=@{{related_id}}" target="_blank" data-toggle="tooltip" ng-repeat="related_id in ticket.ticket_order.ticket_related" title="Click để xem chi tiết">
                                    <i class="fa fa-ticket"></i>
                                </a>)
                            </div>
                        </div>
                        <div ng-show="ticket.relastedOrders.length > 0">
                            <hr>
                            <strong><i class="fa fa-book margin-r-5"></i> Đơn hàng liên quan</strong>
                            <div class="slimScrollDiv" style="position: relative; overflow: auto; width: auto; height: 250px; padding: 5px;"> 
                                <div ng-repeat="order in ticket.relastedOrders" class="box box-solid"> 
                                    <div class="box-header with-border" style="color: #777;">
                                        <h5 class="box-title" style="font-size: 14px;">Mã: <b>@{{order.code}}</b></h5>
                                        <div class="box-tools">
                                            <div class="checkbox" style="margin-top: 0; margin-bottom: 0;">
                                                <label>
                                                    <input type="checkbox" ng-true-value="1" ng-model="order.is_refund" ng-change="approveRefund(order)" ng-false-value="0"> Duyệt hoàn tiền
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <p class="text-muted">Khách hàng: <b>@{{order.full_name}}</b></p>
                                        <p class="text-muted">Điện thoại: <b>@{{order.phone}}</b></p>
                                        <p class="text-muted">Email: <b>@{{order.email}}</b></p>
                                        <p class="text-muted">Địa chỉ: @{{order.address}}</p>
                                        <p class="text-muted">Ngày mua: @{{summarizeDateTime(order.created_at, true)}}</p>
                                        <p class="text-muted">Loại vận chuyển: <b style="text-transform: capitalize;">@{{order.shipping_type}}</b></p>
                                        <p class="text-muted">Phí vận chuyển: <b>@{{order.shipping_fee}}</b></p>
                                        <p class="text-muted">Tổng tiền: <b ng-show="ticket.locate == 'jp' && order.amount_show == null">@{{order.amount | currency: '' :0}}</b> 
                                                                        <b ng-show="ticket.locate != 'jp' && order.amount_show == null">@{{order.amount}}</b>
                                                                        <b ng-show="order.amount_show != null">@{{order.amount_show}}</b>
                                        </p>
                                        <p class="text-muted">Trạng thái: <b>@{{orderStatus[order.status]}}</b></p>
                                        <p class="text-muted">Trạng thái thanh toán: <b>@{{paymentStatus[order.payment_status]}}</b></p>
                                        <p class="text-muted">Xác nhận: <b>@{{order.verifier}}</b></p>
                                        <p class="text-muted" ng-show="order.trackings.length > 0">
                                            Tracking code:
                                        </p>
                                        <p ng-repeat="tracking in order.trackings">
                                            <a href="@{{tracking.url}}" target="_blank">@{{tracking.code}}</a>
                                            <a href="javascript:;" class="btn btn-sm btn-info" ng-click="copyToClipboard(tracking)">Copy link</a>
                                        </p>
                                        <p class="text-muted">Ghi chú bán hàng:
                                            <button type="button" ng-show="!isOpenOrderNote" ng-click="isOpenOrderNote = true" class="btn btn-sm btn-primary pull-right">Sửa</button>
                                            <button type="button" ng-click="isOpenOrderNote = false" ng-show="isOpenOrderNote" class="btn btn-sm btn-default pull-right">Đóng</button>
                                            <button type="button" ng-click="updateOrderNote(order, ticket.locate, 'note')" ng-show="isOpenOrderNote" style="margin-right: 3px;" class="btn btn-sm btn-primary pull-right">Lưu</button>
                                        </p>
                                        <p>
                                            <span ng-show="!isOpenOrderNote" style="color:#777;">@{{order.note}}</span>
                                            <textarea ng-show="isOpenOrderNote" class="form-control" rows="3" ng-model="order.note"></textarea>
                                        </p>

                                        <p class="text-muted">Ghi chú giao hàng:
                                            <button type="button" ng-show="!isOpenOrderDeliveryNote" ng-click="isOpenOrderDeliveryNote = true" class="btn btn-sm btn-primary pull-right">Sửa</button>
                                            <button type="button" ng-click="isOpenOrderDeliveryNote = false" ng-show="isOpenOrderDeliveryNote" class="btn btn-sm btn-default pull-right">Đóng</button>
                                            <button type="button" ng-click="updateOrderNote(order, ticket.locate, 'delivery_note')" ng-show="isOpenOrderDeliveryNote" style="margin-right: 3px;" class="btn btn-sm btn-primary pull-right">Lưu</button>
                                        </p>
                                        <p>
                                            <span ng-show="!isOpenOrderDeliveryNote" style="color:#777;">@{{order.delivery_note}}</span>
                                            <textarea ng-show="isOpenOrderDeliveryNote" class="form-control" rows="3" ng-model="order.delivery_note"></textarea>
                                        </p>
                                        <p class="text-muted" ng-repeat="item in order.items">
                                            <a href="https://printerval.com/@{{ticket.locate}}/@{{item.slug}}" title="@{{item.name}}" target="_blank">
                                                @{{item.name}}
                                            </a>
                                            (Slg: @{{item.quantity}})
                                        </p>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-default pull-right"  ng-click="cancelSaveTicketOrder()">Hủy</button>
                                <button type="button" class="btn btn-primary pull-right" style="margin-right: 4px;" ng-show="mode == 'update' && ticket.ticket_n_order.length > 0" ng-click="saveTicketOrder(ticket)">Lưu</button>
                                   
                            </div>  
                        </div>
                        <div ng-show="isGetOrder">
                            <hr>
                            <strong>
                                <div class="overlay">
                                    <i class="fa fa-refresh fa-spin"></i>
                                    Đang tìm đơn liên quan
                                </div>
                            </strong>
                        </div>
                        <div ng-show="ticket.relastedOrders.length == 0 && !isGetOrder">
                            <hr>
                            <div class="form-group">
                                <label for="">Tìm đơn thủ công</label>
                                <div class="input-group">
                                    <input class="form-control" ng-model="ticket.order_codes" style="height: 32px;" ng-keydown="$event.keyCode === 13 && mapOrder(ticket)" placeholder="Nhập mã đơn hàng">
                                    <div class="input-group-btn">
                                        <button type="button" ng-click="mapOrder(ticket);" class="btn btn-success"><i class="fa fa-search"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div style="position: relative; overflow: auto; width: auto; height: 250px; padding: 5px;">
                            <div class="form-group">
                                <label for="">Trạng thái</label>
                                <select class="form-control" ng-options="key as value for (key, value) in statuses" ng-model="ticket.status" ng-change="updateStatus(ticket)"></select>
                            </div>
                            <div class="form-group">
                                <label for="">Loại ticket</label>
                                <select class="form-control" ng-options="key as value for (key, value) in types" ng-model="ticket.type" ng-change="updateType(ticket)">
                                    <option value="">Chưa xác định</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="">Nhân viên xử lý</label>
                                <select class="form-control" ng-options="key as value for (key, value) in users" ng-model="ticket.user_id" ng-change="updateUser(ticket)">
                                    <option value="">Chưa xác định</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="">Thị trường</label>
                                <select class="form-control" ng-options="key as value for (key, value) in locates" ng-model="ticket.locate" ng-change="updateMarket(ticket)">
                                    <option value="">Chưa xác định</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="">Hạn kết thúc</label>
                                <input my-date-picker type="text" ng-model="ticket.deadline" ng-change="updateDeadline(ticket)" class="form-control"/>
                            </div>
                            <div class="form-group">
                                <label for="">Ghi chú Ticket</label>
                                <button type="button" ng-show="!isOpenNote" ng-click="isOpenNote = true" class="btn btn-sm btn-primary pull-right">Sửa</button>
                                <div class="btn-group pull-right" ng-show="isOpenNote">
                                    <button type="button" ng-click="updateNote(ticket)" ng-show="mode == 'update'" style="margin-right: 3px;" class="btn btn-sm btn-primary">Lưu</button>
                                    <button type="button" ng-click="isOpenNote = false" class="btn btn-sm btn-default">Đóng</button>
                                </div>
                                <p ng-show="!isOpenNote">@{{ticket.note}}</p>
                                <textarea ng-show="isOpenNote" class="form-control" rows="3" ng-model="ticket.note"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card direct-chat direct-chat-primary">
                            <div class="card-body">
                                <div class="form-group" ng-show="mode == 'update' && ticket.ticket_items.length > 0">
                                    <div class="direct-chat-messages" style="min-height: 360px;">
                                        <div ng-repeat="item in ticket.ticket_items | reverse">
                                            <div class="direct-chat-msg" ng-show="item.type == 'customer'">
                                                <div class="direct-chat-infos clearfix">
                                                    <span class="direct-chat-name float-left">@{{ticket.email}}</span>
                                                    <span class="direct-chat-timestamp float-right">@{{summarizeDateTime(item.created_at, true)}}</span>
                                                </div>
                                                <img class="direct-chat-img" src="/modules/ticket/images/customer.png" alt="message user image">
                                                <div class="direct-chat-text angular-with-newlines" ng-bind-html="item.content">
                                                </div>
                                                <ul ng-if="item.files.length > 0" class="mailbox-attachments d-flex align-items-stretch clearfix" style="margin-top: 5px;">
                                                    <li ng-repeat="file in item.files" style="width: 14px; border: none; float: right;margin-right: 5px">
                                                        <a href="@{{file.path}}" class="btn-link text-secondary" target="_blank" title="Ảnh" download><i class="fa fa-paperclip"></i></a>
                                                    </li>
                                                    <li style="border: none; float: right; width:60px; margin-right: 5px; margin-bottom: 0; font-weight: bold; font-size:10px">Attachments: </li>
                                                </ul>
                                            </div>
                                            <div class="direct-chat-msg right" ng-show="item.type == 'staff'">
                                                <div class="direct-chat-infos clearfix">
                                                    <span class="direct-chat-name float-right">@{{users[item.user_id]}}</span>
                                                    <span class="direct-chat-timestamp float-left">@{{summarizeDateTime(item.created_at, true)}}</span>
                                                </div>
                                                <img class="direct-chat-img" src="/modules/ticket/images/staff.jpeg" alt="message user image">
                                                <div class="direct-chat-text" ng-bind-html="item.content">
                                                </div>
                                                <ul ng-if="item.files.length > 0" class="mailbox-attachments d-flex align-items-stretch clearfix" style="margin-top: 5px;">
                                                    <li style="border: none; float: left; width:60px; margin-right: 5px; margin-bottom: 0; font-weight: bold; font-size:10px">Attachments: </li>
                                                    <li ng-repeat="file in item.files" style="width: 14px; border: none; float: left;margin-right: 5px">
                                                        <a href="@{{file.path}}" class="btn-link text-secondary" target="_blank" title="Ảnh" download><i class="fa fa-paperclip"></i></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="direct-chat-msg right" id="last-message" style="position: bottom;"></div>
                                    </div>
                                </div>
                                <div class="form-group" ng-show="mode == 'create' || ticket.ticket_items.length == 0">
                                    <label>Tiêu đề</label>
                                    <input class="form-control" ng-show="mode == 'create'" ng-model="ticket.title"  placeholder="Tiêu đề email">
                                    <input class="form-control" ng-show="mode == 'update' && ticket.ticket_items.length == 0" disabled ng-model="ticket.title"  placeholder="Tiêu đề email">
                                </div>
                                <div class="form-group" ng-if="mode == 'create' || ticket.ticket_items.length == 0">
                                    <label>Nội dung</label>
                                    <textarea class="form-control" rows="3" ck-editor-ticket height="220" ng-model="ticket.answer_text" placeholder="Enter ..."></textarea>
                                </div>
                                <div class="form-group" ng-if="mode == 'update' && ticket.ticket_items.length > 0">
                                    <label>Trả lời</label>
                                    <textarea class="form-control" rows="3" ck-editor-ticket height="120" ng-model="ticket.answer_text" placeholder="Enter ..."></textarea>
                                </div>
                                <!-- <div class="form-group">
                                    <label for="">Images (Up to 5 images)</label> <p ng-if="uploading">Please wait! Uploading . . .</p> <br>
                                    <a href="javascript:void(0)" ng-if="!uploading" ngf-select="uploadImages($files)" multiple="multiple" class="btn-upload-image">
                                        <i class="fa fa-cloud-upload" aria-hidden="true"></i> Choose files
                                    </a>
                                </div>
                                <div class="form-group">
                                    <span class="sb_image" ng-repeat="img in ticket.answer_files">
                                        <img class="comment-image" height="58px" ng-src="@{{ img.path }}">
                                        <div class="middle">
                                            <button type="button" name="button" class="btn btn-default btm-xs" ng-click="removeImage($index)" title="Xóa ảnh này"><i class="fa fa-trash"></i></button>
                                        </div>
                                    </span>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" ng-click="save()" ng-disabled="isSaving" class="btn btn-primary">Gửi</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Đóng</button>
            </div>
        </div>
    </div>
</div>
