<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'contact', 'middleware' => ['web', 'frontend']], function () {
    Route::get('/ticket', [
        'as' => 'ticket::home',
        'uses' => 'TicketController@index',
    ]);
});

Route::group(['middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/tickets', [
        'as' => 'ticket::system',
        'uses' => 'TicketController@system',
    ]);
    Route::get('/tickets/config', [
        'as' => 'ticket::config',
        'uses' => 'TicketController@config'
    ]);
});

Route::group(['prefix' => "/ticket"], function () {
    Route::get('/rebuild-reply', [
        'as' => 'ticket::rebuild-reply',
        'uses' => 'Services\TicketService@rebuildReply',
    ]);
    Route::get('/rebuild-ticket', [
        'as' => 'ticket::rebuild-ticket',
        'uses' => 'Services\TicketService@rebuildTicket',
    ]);
    Route::get('/find', [
        'as' => 'ticket::find',
        'uses' => 'Services\TicketService@find',
    ]);
    Route::post('/send', [
        'as' => 'ticket::save',
        'uses' => 'Services\TicketService@saveCustomer',
    ]);
    Route::patch('/update-status', [
        'as' => 'ticket::update-status',
        'uses' => 'Services\TicketService@updateStatus',
    ]);
    Route::post('/item', [
        'as' => 'ticket::create-ticket-item',
        'uses' => 'Services\TicketService@createTicketItem',
    ]);
    Route::get('/get-order', [
        'as' => 'ticket::get-order',
        'uses' => 'Services\TicketService@getOrder'
    ]);
    Route::post('/send-question', [
        'as' => 'ticket::send-question',
        'uses' => 'Services\TicketService@sendQuestion',
    ]);
    Route::post('/update-multiple', [
        'as' => 'ticket::update-multiple',
        'uses' => 'Services\TicketService@updateMultiple'
    ]);
    Route::post('/map-order', [
        'as' => 'ticket::map-order',
        'uses' => 'Services\TicketService@mapOrder'
    ]);
    Route::post('/save-ticket-order', [
        'as' => 'ticket::save-ticket-order',
        'uses' => 'Services\TicketService@saveTicketOrder'
    ]);
    Route::post('/create-ticket', [
        'as' => 'ticket::create-ticket',
        'uses' => 'Services\TicketService@createTicket'
    ]);
    Route::post('/update-order-note', [
        'as' => 'ticket:update-order-note',
        'uses' => 'Services\TicketService@updateOrderNote'
    ]);
    Route::post('send-email', [
        'as' => 'ticket::send-email',
        'uses' => 'Services\TicketService@sendEmail'
    ]);
    Route::post('update-spam', [
        'as' => 'ticket:update-spam',
        'uses' => 'Services\TicketService@updateSpam'
    ]);
    Route::post('update-not-spam', [
        'as' => 'ticket:update-not-spam',
        'uses' => 'Services\TicketService@updateNotSpam'
    ]);
    Route::post('approve-refund', [
        'as' => 'ticket:approve-refund',
        'uses' => 'Services\TicketService@approveRefund'
    ]);
    Route::post('create-filter-spam', [
        'as' => 'ticket::create-filter-spam',
        'uses' => 'Services\TicketService@createFilterSpam'
    ]);
    Route::get('get-filter-spam', [
        'as' => 'ticket:get-filter-spam',
        'uses' => 'Services\TicketService@getFilterSpam'
    ]);
    Route::post('remove-filter-item', [
        'as' => 'ticket:remove-filter-item',
        'uses' => 'Services\TicketService@removeFilterItem'
    ]);

    Route::post('order/create-ticket', [
        'as' => 'ticket:order-create-ticket',
        'uses' => 'Services\TicketService@createTicketFromOrder'
    ]);

    Route::post('/order/load-ticket', [
        'as' => 'ticket:order-load-ticket',
        'uses' => 'Services\TicketService@loadTicket'
    ]);

    Route::get('/assign', [
        'as' => 'ticket::assign',
        'uses' => 'Services\TicketAssignService@assign'
    ]);
    Route::post('/config', [
        'as' => 'config::create',
        'uses' => 'Services\TicketAssignService@store'
    ]);
    Route::patch('/config/update', [
        'as' => 'config::update',
        'uses' => 'Services\TicketAssignService@store',
    ]);
    Route::get('/config/find', [
        'as' => 'config::find',
        'uses' => 'Services\TicketAssignService@find',
    ]);
    Route::get('/backup', [
        'as' => 'ticket::backup',
        'uses' => 'TicketController@backup'
    ]);
});



Route::get('/ticket/google/gmail', [
    'as' => 'ticket::gmail',
    'uses' => 'GmailController@index',
]);

Route::get('/ticket/google/login', [
    'as' => 'ticket::login',
    'uses' => 'GmailController@login',
]);

Route::get('/ticket/google/callback', [
    'as' => 'ticket::google::callback',
    'uses' => 'GmailController@callback',
]);

Route::get('/ticket/google/refresh', [
    'as' => 'ticket::google::refresh',
    'uses' => 'GmailController@refreshToken',
]);
