<?php
Modules\Ticket\Helpers\DBConnect::connect();
use Modules\Ticket\Models\Ticket;

Module::onVariable('system.menu', function (&$menu) {
    if (hasPermission('tickets')) {
        $count = Ticket::where('status', 'open')
            ->where('is_reply', '=', 0)->count();
        $menu[] = [
            'icon' => '<i class="fa fa-comments-o"></i>',
            'title' => 'Help Center',
            'url' => '/tickets',
            'badge' => $count ? '<label class="ml-2 mt-2 label label-danger">'. $count .'</label>' : '',
            'children' => [
                [
                    'icon' => '<i class="fa fa-comments-o"></i>',
                    'title' => 'Quản lí ticket',
                    'url' => '/tickets',
                ],
                [
                    'icon' => '<i class="fa fa-user"></i>',
                    'title' => 'Cấu hình nhân viên',
                    'url' => '/tickets/config',
                ],
            ]
        ];
    }
    return $menu;
});

Module::onView('end-body', function () {
    if (config('ticket::sa.ticket_btn.enable', false)) {
        return view('ticket::frontend.ticket-btn');
    }
});

Module::onView('ticket-order-view', function () {
    return view('ticket::system.order.fulfillment')->render();
}, 10);
