<?php

namespace Modules\TrackingOrder\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{

    protected $table = "order";

    public function orderMeta() {
        return $this->hasMany(OrderMeta::class);
    }

    public function orderItems() {
        return $this->hasMany(OrderItem::class);
    }

    public function timelines() {
        return $this->hasMany(OrderTimeline::class);
    }

    public function scopeSearch($query, $params) {
        if (isset($params['keyword'])) {
            $re = '/[A-Z]+_[0-9]{10}-([A-Z0-9]{1,9})/m';
            preg_match_all($re, $params['keyword'], $matches, PREG_SET_ORDER, 0);
            if (!empty($matches[0][1])) {
                $query->where('order.code', '=', $matches[0][1])
                    ->orWhere(\Illuminate\Support\Facades\DB::raw('BINARY `id`'), '=', $matches[0][1]);
            } else if (strpos($params['keyword'], '^') !== false ) {
                $search = str_replace('^', '', $params['keyword']);
                if ($search) {
                    $arrCode = explode(' ', $search);
                    if ($arrCode) {
                        foreach ($arrCode as $key => $value) {
                            $arrCode[$key] = trim($value);
                        }
                        $query->whereIn('order.code', $arrCode);
                    }
                }

            } else {
                $query->where('order.code', '=', $params['keyword'])
                    ->orWhere('order.search', 'LIKE', '%' . $params['keyword'] . '%');
            }
        }
    }

    public function scopePrinter($query, $params) {
        $query->whereHas('orderItems', function ($subQuery) use ($params) {
            $subQuery->where('order_item.printing_code', $params['value']);
        });
    }
}
